/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.snapshot;

import co.cask.tephra.ChangeId;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionType;
import co.cask.tephra.TxConstants;
import co.cask.tephra.persist.TransactionSnapshot;
import co.cask.tephra.persist.TransactionStateStorage;
import co.cask.tephra.runtime.ConfigModule;
import co.cask.tephra.runtime.DiscoveryModules;
import co.cask.tephra.runtime.TransactionModules;
import co.cask.tephra.snapshot.DefaultSnapshotCodec;
import co.cask.tephra.snapshot.SnapshotCodecProvider;
import co.cask.tephra.snapshot.SnapshotCodecV3;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SnapshotCodecTest {
    @ClassRule
    public static TemporaryFolder tmpDir = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDefaultToV3Compatibility() throws Exception {
        long now = System.currentTimeMillis();
        long nowWritePointer = now * 1000000L;
        long tInvalid = nowWritePointer - 5L;
        long readPtr = nowWritePointer - 4L;
        long tLong = nowWritePointer - 3L;
        long tCommitted = nowWritePointer - 2L;
        long tShort = nowWritePointer - 1L;
        TreeMap inProgress = Maps.newTreeMap((SortedMap)ImmutableSortedMap.of((Comparable)Long.valueOf(tLong), (Object)new TransactionManager.InProgressTx(readPtr, TransactionManager.getTxExpirationFromWritePointer((long)tLong, (long)TxConstants.Manager.DEFAULT_TX_LONG_TIMEOUT), TransactionType.LONG), (Comparable)Long.valueOf(tShort), (Object)new TransactionManager.InProgressTx(readPtr, now + 1000L, TransactionType.SHORT)));
        TransactionSnapshot snapshot = new TransactionSnapshot(now, readPtr, nowWritePointer, (Collection)Lists.newArrayList((Object[])new Long[]{tInvalid}), (NavigableMap)inProgress, (Map)ImmutableMap.of((Object)tShort, (Object)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(new byte[]{114, 51}), new ChangeId(new byte[]{114, 52})})), (Map)ImmutableMap.of((Object)tCommitted, (Object)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(new byte[]{114, 49}), new ChangeId(new byte[]{114, 50})})));
        Configuration conf1 = new Configuration();
        conf1.set("data.tx.snapshot.codecs", DefaultSnapshotCodec.class.getName());
        SnapshotCodecProvider provider1 = new SnapshotCodecProvider(conf1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            provider1.encode((OutputStream)out, snapshot);
        }
        finally {
            out.close();
        }
        TransactionSnapshot snapshot2 = provider1.decode((InputStream)new ByteArrayInputStream(out.toByteArray()));
        Assert.assertEquals((long)snapshot.getReadPointer(), (long)snapshot2.getReadPointer());
        Assert.assertEquals((long)snapshot.getWritePointer(), (long)snapshot2.getWritePointer());
        Assert.assertEquals((Object)snapshot.getInvalid(), (Object)snapshot2.getInvalid());
        Assert.assertNotEquals((Object)snapshot.getInProgress(), (Object)snapshot2.getInProgress());
        Assert.assertEquals((Object)snapshot.getCommittingChangeSets(), (Object)snapshot2.getCommittingChangeSets());
        Assert.assertEquals((Object)snapshot.getCommittedChangeSets(), (Object)snapshot2.getCommittedChangeSets());
        Map fixedInProgress = TransactionManager.txnBackwardsCompatCheck((int)TxConstants.Manager.DEFAULT_TX_LONG_TIMEOUT, (long)10000L, (Map)snapshot2.getInProgress());
        Assert.assertEquals((Object)snapshot.getInProgress(), (Object)fixedInProgress);
        Assert.assertEquals((Object)snapshot, (Object)snapshot2);
    }

    @Test
    public void testDefaultToV3Migration() throws Exception {
        File testDir = tmpDir.newFolder("testDefaultToV3Migration");
        Configuration conf = new Configuration();
        conf.set("data.tx.snapshot.codecs", DefaultSnapshotCodec.class.getName());
        conf.set("data.tx.snapshot.local.dir", testDir.getAbsolutePath());
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new DiscoveryModules().getSingleNodeModules(), new TransactionModules().getSingleNodeModules()});
        TransactionManager txManager = (TransactionManager)injector.getInstance(TransactionManager.class);
        txManager.startAndWait();
        txManager.startLong();
        txManager.stopAndWait();
        TransactionStateStorage txStorage = (TransactionStateStorage)injector.getInstance(TransactionStateStorage.class);
        txStorage.startAndWait();
        TransactionSnapshot snapshot = txStorage.getLatestSnapshot();
        Assert.assertNotNull((Object)snapshot);
        Assert.assertEquals((long)1L, (long)snapshot.getInProgress().size());
        Map.Entry entry = snapshot.getInProgress().entrySet().iterator().next();
        Assert.assertNull((Object)((TransactionManager.InProgressTx)entry.getValue()).getType());
        Configuration conf2 = new Configuration();
        conf2.set("data.tx.snapshot.local.dir", testDir.getAbsolutePath());
        conf2.setStrings("data.tx.snapshot.codecs", new String[]{DefaultSnapshotCodec.class.getName(), SnapshotCodecV3.class.getName()});
        Injector injector2 = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf2), new DiscoveryModules().getSingleNodeModules(), new TransactionModules().getSingleNodeModules()});
        TransactionManager txManager2 = (TransactionManager)injector2.getInstance(TransactionManager.class);
        txManager2.startAndWait();
        TransactionSnapshot snapshot2 = txManager2.getCurrentState();
        Assert.assertEquals((long)1L, (long)snapshot2.getInProgress().size());
        Map.Entry inProgressTx = snapshot2.getInProgress().entrySet().iterator().next();
        Assert.assertEquals((Object)TransactionType.LONG, (Object)((TransactionManager.InProgressTx)inProgressTx.getValue()).getType());
        txManager2.stopAndWait();
        TransactionStateStorage txStorage2 = (TransactionStateStorage)injector2.getInstance(TransactionStateStorage.class);
        txStorage2.startAndWait();
        TransactionSnapshot snapshot3 = txStorage2.getLatestSnapshot();
        Assert.assertEquals((Object)snapshot2.getInProgress(), (Object)snapshot3.getInProgress());
        Assert.assertEquals((Object)snapshot2, (Object)snapshot3);
    }
}

