/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.persist.TransactionEdit;
import co.cask.tephra.persist.TransactionLog;
import co.cask.tephra.persist.TransactionLogReader;
import co.cask.tephra.persist.TransactionSnapshot;
import co.cask.tephra.persist.TransactionStateStorage;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class InMemoryTransactionStateStorage
extends AbstractIdleService
implements TransactionStateStorage {
    private TransactionSnapshot lastSnapshot;
    private NavigableMap<Long, TransactionLog> logs = new TreeMap<Long, TransactionLog>();

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
        this.lastSnapshot = null;
        this.logs = new TreeMap<Long, TransactionLog>();
    }

    public void writeSnapshot(OutputStream out, TransactionSnapshot snapshot) throws IOException {
    }

    public void writeSnapshot(TransactionSnapshot snapshot) throws IOException {
        this.lastSnapshot = snapshot;
    }

    public TransactionSnapshot getLatestSnapshot() throws IOException {
        return this.lastSnapshot;
    }

    public long deleteOldSnapshots(int numberToKeep) throws IOException {
        return this.lastSnapshot.getTimestamp();
    }

    public List<String> listSnapshots() throws IOException {
        ArrayList snapshots = Lists.newArrayListWithCapacity((int)1);
        if (this.lastSnapshot != null) {
            snapshots.add(Long.toString(this.lastSnapshot.getTimestamp()));
        }
        return snapshots;
    }

    public List<TransactionLog> getLogsSince(long timestamp) throws IOException {
        return Lists.newArrayList(this.logs.tailMap(timestamp).values());
    }

    public TransactionLog createLog(long timestamp) throws IOException {
        InMemoryTransactionLog log = new InMemoryTransactionLog(timestamp);
        this.logs.put(timestamp, log);
        return log;
    }

    public void deleteLogsOlderThan(long timestamp) throws IOException {
        Iterator logIter = this.logs.entrySet().iterator();
        while (logIter.hasNext()) {
            Map.Entry logEntry = logIter.next();
            if ((Long)logEntry.getKey() >= timestamp) continue;
            logIter.remove();
        }
    }

    public List<String> listLogs() throws IOException {
        return Lists.transform((List)Lists.newArrayList(this.logs.keySet()), (Function)new Function<Long, String>(){

            @Nullable
            public String apply(@Nullable Long input) {
                return input.toString();
            }
        });
    }

    public String getLocation() {
        return "in-memory";
    }

    private static class InMemoryLogReader
    implements TransactionLogReader {
        private final Iterator<TransactionEdit> editIterator;

        public InMemoryLogReader(Iterator<TransactionEdit> editIterator) {
            this.editIterator = editIterator;
        }

        public TransactionEdit next() throws IOException {
            if (this.editIterator.hasNext()) {
                return this.editIterator.next();
            }
            return null;
        }

        public TransactionEdit next(TransactionEdit reuse) throws IOException {
            return this.next();
        }

        public void close() throws IOException {
        }
    }

    private static class InMemoryTransactionLog
    implements TransactionLog {
        private long timestamp;
        private List<TransactionEdit> edits = Lists.newArrayList();
        boolean isClosed = false;

        InMemoryTransactionLog(long timestamp) {
            this.timestamp = timestamp;
        }

        public String getName() {
            return "in-memory@" + this.timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void append(TransactionEdit edit) throws IOException {
            if (this.isClosed) {
                throw new IOException("Log is closed");
            }
            this.edits.add(edit);
        }

        public void append(List<TransactionEdit> edits) throws IOException {
            if (this.isClosed) {
                throw new IOException("Log is closed");
            }
            edits.addAll(edits);
        }

        public void close() {
            this.isClosed = true;
        }

        public TransactionLogReader getReader() throws IOException {
            return new InMemoryLogReader(this.edits.iterator());
        }
    }
}

