/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionAdmin;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.distributed.TransactionService;
import co.cask.tephra.persist.InMemoryTransactionStateStorage;
import co.cask.tephra.persist.TransactionStateStorage;
import co.cask.tephra.runtime.ConfigModule;
import co.cask.tephra.runtime.DiscoveryModules;
import co.cask.tephra.runtime.TransactionClientModule;
import co.cask.tephra.runtime.TransactionModules;
import co.cask.tephra.runtime.ZKModule;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.util.Modules;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.internal.zookeeper.InMemoryZKServer;
import org.apache.twill.zookeeper.ZKClientService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionAdminTest {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionAdminTest.class);
    private static Configuration conf;
    private static InMemoryZKServer zkServer;
    private static ZKClientService zkClientService;
    private static TransactionService txService;
    private static TransactionSystemClient txClient;
    @ClassRule
    public static TemporaryFolder tmpFolder;

    @BeforeClass
    public static void start() throws Exception {
        zkServer = InMemoryZKServer.builder().setDataDir(tmpFolder.newFolder()).build();
        zkServer.startAndWait();
        conf = new Configuration();
        conf.setBoolean("tx.persist", false);
        conf.set("data.tx.zookeeper.quorum", zkServer.getConnectionStr());
        conf.set("data.tx.client.retry.strategy", "n-times");
        conf.setInt("data.tx.client.retry.attempts", 1);
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new ZKModule(), new DiscoveryModules().getDistributedModules(), Modules.override((Module[])new Module[]{new TransactionModules().getDistributedModules()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TransactionStateStorage.class).to(InMemoryTransactionStateStorage.class).in(Scopes.SINGLETON);
            }
        }}), new TransactionClientModule()});
        zkClientService = (ZKClientService)injector.getInstance(ZKClientService.class);
        zkClientService.startAndWait();
        txService = (TransactionService)injector.getInstance(TransactionService.class);
        txClient = (TransactionSystemClient)injector.getInstance(TransactionSystemClient.class);
        try {
            LOG.info("Starting transaction service");
            txService.startAndWait();
        }
        catch (Exception e) {
            LOG.error("Failed to start service: ", (Throwable)e);
        }
    }

    @Before
    public void reset() throws Exception {
        txClient.resetState();
    }

    @AfterClass
    public static void stop() throws Exception {
        txService.stopAndWait();
        zkClientService.stopAndWait();
        zkServer.stopAndWait();
    }

    @Test
    public void testPrintUsage() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        TransactionAdmin txAdmin = new TransactionAdmin(new PrintStream(out), new PrintStream(err));
        int status = txAdmin.doMain(new String[0], conf);
        Assert.assertEquals((long)1L, (long)status);
        Assert.assertTrue((boolean)err.toString("UTF-8").startsWith("Usage:"));
        Assert.assertEquals((long)0L, (long)out.toByteArray().length);
    }

    @Test
    public void testTruncateInvalidTx() throws Exception {
        Transaction tx1 = txClient.startLong();
        Transaction tx2 = txClient.startShort();
        txClient.invalidate(tx1.getTransactionId());
        txClient.invalidate(tx2.getTransactionId());
        Assert.assertEquals((long)2L, (long)txClient.getInvalidSize());
        TransactionAdmin txAdmin = new TransactionAdmin(new PrintStream(System.out), new PrintStream(System.err));
        int status = txAdmin.doMain(new String[]{"--truncate-invalid-tx", String.valueOf(tx2.getTransactionId())}, conf);
        Assert.assertEquals((long)0L, (long)status);
        Assert.assertEquals((long)1L, (long)txClient.getInvalidSize());
    }

    @Test
    public void testTruncateInvalidTxBefore() throws Exception {
        Transaction tx1 = txClient.startLong();
        TimeUnit.MILLISECONDS.sleep(1L);
        long beforeTx2 = System.currentTimeMillis();
        Transaction tx2 = txClient.startLong();
        Assert.assertEquals((long)0L, (long)txClient.getInvalidSize());
        TransactionAdmin txAdmin = new TransactionAdmin(new PrintStream(System.out), new PrintStream(System.err));
        int status = txAdmin.doMain(new String[]{"--truncate-invalid-tx-before", String.valueOf(beforeTx2)}, conf);
        Assert.assertEquals((long)1L, (long)status);
        Assert.assertEquals((long)0L, (long)txClient.getInvalidSize());
        txClient.invalidate(tx1.getTransactionId());
        txClient.invalidate(tx2.getTransactionId());
        Assert.assertEquals((long)2L, (long)txClient.getInvalidSize());
        status = txAdmin.doMain(new String[]{"--truncate-invalid-tx-before", String.valueOf(beforeTx2)}, conf);
        Assert.assertEquals((long)0L, (long)status);
        Assert.assertEquals((long)1L, (long)txClient.getInvalidSize());
    }

    @Test
    public void testGetInvalidTxSize() throws Exception {
        Transaction tx1 = txClient.startShort();
        txClient.startLong();
        txClient.invalidate(tx1.getTransactionId());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        TransactionAdmin txAdmin = new TransactionAdmin(new PrintStream(out), new PrintStream(err));
        int status = txAdmin.doMain(new String[]{"--get-invalid-tx-size"}, conf);
        Assert.assertEquals((long)0L, (long)status);
        Assert.assertTrue((boolean)out.toString("UTF-8").contains("Invalid list size: 1\n"));
    }

    static {
        tmpFolder = new TemporaryFolder();
    }
}

