/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.TransactionSystemTest;
import co.cask.tephra.distributed.TransactionService;
import co.cask.tephra.persist.InMemoryTransactionStateStorage;
import co.cask.tephra.persist.TransactionStateStorage;
import co.cask.tephra.runtime.ConfigModule;
import co.cask.tephra.runtime.DiscoveryModules;
import co.cask.tephra.runtime.TransactionClientModule;
import co.cask.tephra.runtime.TransactionModules;
import co.cask.tephra.runtime.ZKModule;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.util.Modules;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.internal.zookeeper.InMemoryZKServer;
import org.apache.twill.zookeeper.ZKClientService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftTransactionSystemTest
extends TransactionSystemTest {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftTransactionSystemTest.class);
    private static InMemoryZKServer zkServer;
    private static ZKClientService zkClientService;
    private static TransactionService txService;
    private static TransactionStateStorage storage;
    private static TransactionSystemClient txClient;
    @ClassRule
    public static TemporaryFolder tmpFolder;

    @BeforeClass
    public static void start() throws Exception {
        zkServer = InMemoryZKServer.builder().setDataDir(tmpFolder.newFolder()).build();
        zkServer.startAndWait();
        Configuration conf = new Configuration();
        conf.setBoolean("tx.persist", false);
        conf.set("data.tx.zookeeper.quorum", zkServer.getConnectionStr());
        conf.set("data.tx.client.retry.strategy", "n-times");
        conf.setInt("data.tx.client.retry.attempts", 1);
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new ZKModule(), new DiscoveryModules().getDistributedModules(), Modules.override((Module[])new Module[]{new TransactionModules().getDistributedModules()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TransactionStateStorage.class).to(InMemoryTransactionStateStorage.class).in(Scopes.SINGLETON);
            }
        }}), new TransactionClientModule()});
        zkClientService = (ZKClientService)injector.getInstance(ZKClientService.class);
        zkClientService.startAndWait();
        txService = (TransactionService)injector.getInstance(TransactionService.class);
        storage = (TransactionStateStorage)injector.getInstance(TransactionStateStorage.class);
        txClient = (TransactionSystemClient)injector.getInstance(TransactionSystemClient.class);
        try {
            LOG.info("Starting transaction service");
            txService.startAndWait();
        }
        catch (Exception e) {
            LOG.error("Failed to start service: ", (Throwable)e);
        }
    }

    @Before
    public void reset() throws Exception {
        this.getClient().resetState();
    }

    @AfterClass
    public static void stop() throws Exception {
        txService.stopAndWait();
        storage.stopAndWait();
        zkClientService.stopAndWait();
        zkServer.stopAndWait();
    }

    @Override
    protected TransactionSystemClient getClient() throws Exception {
        return txClient;
    }

    @Override
    protected TransactionStateStorage getStateStorage() throws Exception {
        return storage;
    }

    static {
        tmpFolder = new TemporaryFolder();
    }
}

