/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.ChangeId;
import co.cask.tephra.persist.TransactionEdit;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;

public class TransactionEditTest {
    private static final byte[] COL = new byte[]{99};

    @Test
    public void testV1SerdeCompat() throws Exception {
        TransactionEdit.TransactionEditCodecV1 olderCodec = new TransactionEdit.TransactionEditCodecV1();
        this.verifyDecodingSupportsOlderVersion(TransactionEdit.createStarted((long)2L, (long)0L, (long)1000L, null), (TransactionEdit.TransactionEditCodec)olderCodec);
        this.verifyDecodingSupportsOlderVersion(TransactionEdit.createCommitted((long)2L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(COL)}), (long)3L, (boolean)true), (TransactionEdit.TransactionEditCodec)olderCodec);
    }

    @Test
    public void testV2SerdeCompat() throws Exception {
        TransactionEdit.TransactionEditCodecV2 olderCodec = new TransactionEdit.TransactionEditCodecV2();
        this.verifyDecodingSupportsOlderVersion(TransactionEdit.createStarted((long)2L, (long)100L, (long)1000L, null), (TransactionEdit.TransactionEditCodec)olderCodec);
        this.verifyDecodingSupportsOlderVersion(TransactionEdit.createCommitted((long)2L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(COL)}), (long)3L, (boolean)true), (TransactionEdit.TransactionEditCodec)olderCodec);
    }

    private void verifyDecodingSupportsOlderVersion(TransactionEdit edit, TransactionEdit.TransactionEditCodec olderCodec) throws IOException {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        olderCodec.encode(edit, (DataOutput)out);
        TransactionEdit decodedEdit = new TransactionEdit();
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])out.toByteArray());
        decodedEdit.readFields((DataInput)in);
        Assert.assertEquals((Object)edit, (Object)decodedEdit);
    }
}

