/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.persist.CommitMarkerCodec;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CommitMarkerCodecTest {
    @ClassRule
    public static final TemporaryFolder TMP_FOLDER = new TemporaryFolder();
    private static final String LOG_FILE = "txlog";
    private static final Random RANDOM = new Random();
    private static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem fs;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration hConf = new Configuration();
        hConf.set("hdfs.minidfs.basedir", TMP_FOLDER.newFolder().getAbsolutePath());
        dfsCluster = new MiniDFSCluster.Builder(hConf).numDataNodes(1).build();
        conf = new Configuration(dfsCluster.getFileSystem().getConf());
        fs = FileSystem.newInstance((URI)FileSystem.getDefaultUri((Configuration)conf), (Configuration)conf);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        dfsCluster.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRandomCommitMarkers() throws Exception {
        ArrayList<Integer> randomInts = new ArrayList<Integer>();
        Path newLog = new Path(TMP_FOLDER.newFolder().getAbsolutePath(), LOG_FILE);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)newLog, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        try {
            for (int i = 0; i < 1000; ++i) {
                int randomNum = RANDOM.nextInt(Integer.MAX_VALUE);
                CommitMarkerCodec.writeMarker((SequenceFile.Writer)writer, (int)randomNum);
                randomInts.add(randomNum);
            }
            writer.hflush();
            writer.hsync();
        }
        finally {
            writer.close();
        }
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, newLog, conf);
        try {
            CommitMarkerCodec markerCodec = new CommitMarkerCodec();
            try {
                Iterator i$ = randomInts.iterator();
                while (i$.hasNext()) {
                    int num = (Integer)i$.next();
                    Assert.assertEquals((long)num, (long)markerCodec.readMarker(reader));
                }
            }
            finally {
                markerCodec.close();
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncompleteCommitMarker() throws Exception {
        Path newLog = new Path(TMP_FOLDER.newFolder().getAbsolutePath(), LOG_FILE);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)newLog, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        try {
            String key = "count";
            IncompleteValueBytes valueBytes = new IncompleteValueBytes();
            writer.appendRaw(key.getBytes(), 0, key.length(), (SequenceFile.ValueBytes)valueBytes);
            writer.hflush();
            writer.hsync();
        }
        finally {
            writer.close();
        }
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, newLog, conf);
            try {
                CommitMarkerCodec markerCodec = new CommitMarkerCodec();
                try {
                    markerCodec.readMarker(reader);
                    Assert.fail((String)"Expected EOF Exception to be thrown");
                }
                finally {
                    markerCodec.close();
                }
            }
            finally {
                reader.close();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncorrectCommitMarker() throws Exception {
        Path newLog = new Path(TMP_FOLDER.newFolder().getAbsolutePath(), LOG_FILE);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)newLog, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
        try {
            String invalidKey = "IncorrectKey";
            CommitMarkerCodec.CommitEntriesCount valueBytes = new CommitMarkerCodec.CommitEntriesCount(100);
            writer.appendRaw(invalidKey.getBytes(), 0, invalidKey.length(), (SequenceFile.ValueBytes)valueBytes);
            writer.hflush();
            writer.hsync();
        }
        finally {
            writer.close();
        }
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, newLog, conf);
            try {
                CommitMarkerCodec markerCodec = new CommitMarkerCodec();
                try {
                    markerCodec.readMarker(reader);
                    Assert.fail((String)"Expected an IOException to be thrown");
                }
                finally {
                    markerCodec.close();
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class IncompleteValueBytes
    implements SequenceFile.ValueBytes {
        private IncompleteValueBytes() {
        }

        public void writeUncompressedBytes(DataOutputStream outStream) throws IOException {
        }

        public void writeCompressedBytes(DataOutputStream outStream) throws IllegalArgumentException, IOException {
            throw new IllegalArgumentException("Not possible");
        }

        public int getSize() {
            return 4;
        }
    }
}

