/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.distributed;

import co.cask.tephra.distributed.ElasticPool;
import com.google.common.base.Throwables;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ElasticPoolTest {
    @Test(timeout=5000L)
    public void testFewerThreadsThanElements() throws InterruptedException {
        DummyPool pool = new DummyPool(5);
        Dummy.count.set(0);
        this.createAndRunThreads(2, pool, false);
        Assert.assertEquals((long)2L, (long)Dummy.count.get());
    }

    @Test(timeout=5000L)
    public void testMoreThreadsThanElements() throws InterruptedException {
        DummyPool pool = new DummyPool(2);
        Dummy.count.set(0);
        this.createAndRunThreads(5, pool, false);
        Assert.assertEquals((long)2L, (long)Dummy.count.get());
    }

    @Test(timeout=5000L)
    public void testMoreThreadsThanElementsWithDiscard() throws InterruptedException {
        DummyPool pool = new DummyPool(2);
        Dummy.count.set(0);
        int numThreads = 3;
        this.createAndRunThreads(numThreads, pool, true);
        Assert.assertEquals((long)(5 * numThreads), (long)Dummy.count.get());
    }

    private void createAndRunThreads(int numThreads, final DummyPool pool, final boolean discardAtEnd) throws InterruptedException {
        Thread[] threads = new Thread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            threads[i] = new Thread(){

                @Override
                public void run() {
                    for (int j = 0; j < 5; ++j) {
                        Dummy dummy;
                        try {
                            dummy = (Dummy)pool.obtain();
                        }
                        catch (InterruptedException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (discardAtEnd) {
                            dummy.markInvalid();
                        }
                        pool.release(dummy);
                    }
                }
            };
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            t.join();
        }
    }

    class DummyPool
    extends ElasticPool<Dummy, RuntimeException> {
        public DummyPool(int sizeLimit) {
            super(sizeLimit);
        }

        protected Dummy create() {
            return new Dummy();
        }

        protected boolean recycle(Dummy element) {
            return element.isValid();
        }
    }

    static class Dummy {
        static AtomicInteger count = new AtomicInteger(0);
        boolean valid = true;

        Dummy() {
            count.incrementAndGet();
        }

        void markInvalid() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

