/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.ChangeId;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionType;
import co.cask.tephra.TxConstants;
import co.cask.tephra.metrics.TxMetricsCollector;
import co.cask.tephra.persist.AbstractTransactionStateStorage;
import co.cask.tephra.persist.AbstractTransactionStateStorageTest;
import co.cask.tephra.persist.LocalFileTransactionStateStorage;
import co.cask.tephra.persist.TransactionEdit;
import co.cask.tephra.persist.TransactionLog;
import co.cask.tephra.persist.TransactionSnapshot;
import co.cask.tephra.persist.TransactionStateStorage;
import co.cask.tephra.snapshot.DefaultSnapshotCodec;
import co.cask.tephra.snapshot.SnapshotCodecProvider;
import co.cask.tephra.snapshot.SnapshotCodecV2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalTransactionStateStorageTest
extends AbstractTransactionStateStorageTest {
    @ClassRule
    public static TemporaryFolder tmpDir = new TemporaryFolder();

    @Override
    protected Configuration getConfiguration(String testName) throws IOException {
        File testDir = tmpDir.newFolder(testName);
        Configuration conf = new Configuration();
        conf.set("data.tx.snapshot.local.dir", testDir.getAbsolutePath());
        conf.set("data.tx.snapshot.codecs", SnapshotCodecV2.class.getName());
        return conf;
    }

    @Override
    protected AbstractTransactionStateStorage getStorage(Configuration conf) {
        return new LocalFileTransactionStateStorage(conf, new SnapshotCodecProvider(conf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLongTxnBackwardsCompatibility() throws Exception {
        Configuration conf = this.getConfiguration("testLongTxnBackwardsCompatibility");
        String latestSnapshotCodec = conf.get("data.tx.snapshot.codecs");
        conf.set("data.tx.snapshot.codecs", DefaultSnapshotCodec.class.getName());
        AbstractTransactionStateStorage storage = null;
        try {
            storage = this.getStorage(conf);
            storage.startAndWait();
            ArrayList invalid = Lists.newArrayList();
            TreeMap inProgress = Maps.newTreeMap();
            long time1 = System.currentTimeMillis();
            long wp1 = time1 * 1000000L;
            inProgress.put(wp1, new TransactionManager.InProgressTx(wp1 - 5L, -1L));
            long time2 = time1 + 100L;
            long wp2 = time2 * 1000000L;
            inProgress.put(wp2, new TransactionManager.InProgressTx(wp2 - 50L, time2 + 1000L));
            HashMap committing = Maps.newHashMap();
            HashMap committed = Maps.newHashMap();
            TransactionSnapshot snapshot = new TransactionSnapshot(time2, 0L, wp2, (Collection)invalid, (NavigableMap)inProgress, (Map)committing, (Map)committed);
            long time3 = time1 + 200L;
            long wp3 = time3 * 1000000L;
            TransactionEditV2 edit1 = new TransactionEditV2(wp3, wp3 - 10L, TransactionEdit.State.INPROGRESS, -1L, null, 0L, false, null);
            long time4 = time1 + 300L;
            long wp4 = time4 * 1000000L;
            TransactionEditV2 edit2 = new TransactionEditV2(wp4, wp4 - 10L, TransactionEdit.State.INPROGRESS, time4 + 1000L, null, 0L, false, null);
            storage.writeSnapshot(snapshot);
            TransactionLog log = storage.createLog(time2);
            log.append((TransactionEdit)edit1);
            log.append((TransactionEdit)edit2);
            log.close();
            conf.set("data.tx.snapshot.codecs", latestSnapshotCodec);
            long longTimeout = TimeUnit.SECONDS.toMillis(conf.getLong("data.tx.long.timeout", (long)TxConstants.Manager.DEFAULT_TX_LONG_TIMEOUT));
            TransactionManager txm = new TransactionManager(conf, (TransactionStateStorage)storage, new TxMetricsCollector());
            txm.startAndWait();
            try {
                TransactionSnapshot snapshot1 = txm.getCurrentState();
                Assert.assertEquals((Object)ImmutableSortedSet.of((Comparable)Long.valueOf(wp1), (Comparable)Long.valueOf(wp2), (Comparable)Long.valueOf(wp3), (Comparable)Long.valueOf(wp4)), snapshot1.getInProgress().keySet());
                this.verifyInProgress((TransactionManager.InProgressTx)snapshot1.getInProgress().get(wp1), TransactionType.LONG, time1 + longTimeout);
                this.verifyInProgress((TransactionManager.InProgressTx)snapshot1.getInProgress().get(wp2), TransactionType.SHORT, time2 + 1000L);
                this.verifyInProgress((TransactionManager.InProgressTx)snapshot1.getInProgress().get(wp3), TransactionType.LONG, time3 + longTimeout);
                this.verifyInProgress((TransactionManager.InProgressTx)snapshot1.getInProgress().get(wp4), TransactionType.SHORT, time4 + 1000L);
                Assert.assertEquals((long)0L, (long)snapshot1.getInvalid().size());
            }
            finally {
                txm.stopAndWait();
            }
        }
        finally {
            if (storage != null) {
                storage.stopAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbortEditBackwardsCompatibility() throws Exception {
        Configuration conf = this.getConfiguration("testAbortEditBackwardsCompatibility");
        AbstractTransactionStateStorage storage = null;
        try {
            storage = this.getStorage(conf);
            storage.startAndWait();
            long time1 = System.currentTimeMillis();
            long wp1 = time1 * 1000000L;
            TransactionEditV2 edit1 = new TransactionEditV2(wp1, wp1 - 10L, TransactionEdit.State.INPROGRESS, -1L, null, 0L, false, null);
            TransactionEditV2 edit2 = new TransactionEditV2(wp1, 0L, TransactionEdit.State.ABORTED, 0L, null, 0L, false, null);
            long time2 = time1 + 400L;
            long wp2 = time2 * 1000000L;
            TransactionEditV2 edit3 = new TransactionEditV2(wp2, wp2 - 10L, TransactionEdit.State.INPROGRESS, time2 + 10000L, null, 0L, false, null);
            TransactionEditV2 edit4 = new TransactionEditV2(wp2, 0L, TransactionEdit.State.INVALID, 0L, null, 0L, false, null);
            TransactionEditV2 edit5 = new TransactionEditV2(wp2, 0L, TransactionEdit.State.ABORTED, 0L, null, 0L, false, null);
            TransactionLog log = storage.createLog(time1);
            log.append((TransactionEdit)edit1);
            log.append((TransactionEdit)edit2);
            log.append((TransactionEdit)edit3);
            log.append((TransactionEdit)edit4);
            log.append((TransactionEdit)edit5);
            log.close();
            TransactionManager txm = new TransactionManager(conf, (TransactionStateStorage)storage, new TxMetricsCollector());
            txm.startAndWait();
            try {
                TransactionSnapshot snapshot1 = txm.getCurrentState();
                Assert.assertEquals((Object)ImmutableList.of((Object)wp1, (Object)wp2), (Object)snapshot1.getInvalid());
                Assert.assertEquals((long)0L, (long)snapshot1.getInProgress().size());
                Assert.assertEquals((long)0L, (long)snapshot1.getCommittedChangeSets().size());
                Assert.assertEquals((long)0L, (long)snapshot1.getCommittingChangeSets().size());
            }
            finally {
                txm.stopAndWait();
            }
        }
        finally {
            if (storage != null) {
                storage.stopAndWait();
            }
        }
    }

    private void verifyInProgress(TransactionManager.InProgressTx inProgressTx, TransactionType type, long expiration) throws Exception {
        Assert.assertEquals((Object)type, (Object)inProgressTx.getType());
        Assert.assertTrue((inProgressTx.getExpiration() == expiration ? 1 : 0) != 0);
    }

    private class TransactionEditV2
    extends TransactionEdit {
        public TransactionEditV2(long writePointer, long visibilityUpperBound, TransactionEdit.State state, long expirationDate, Set<ChangeId> changes, long commitPointer, boolean canCommit, TransactionType type) {
            super(writePointer, visibilityUpperBound, state, expirationDate, changes, commitPointer, canCommit, type, null, 0L);
        }

        public void write(DataOutput out) throws IOException {
            new TransactionEdit.TransactionEditCodecV2().encode((TransactionEdit)this, out);
        }
    }
}

