/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.TransactionServiceMain;
import co.cask.tephra.distributed.TransactionServiceClient;
import com.google.common.base.Throwables;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.internal.zookeeper.InMemoryZKServer;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TransactionServiceMainTest {
    @ClassRule
    public static TemporaryFolder tmpFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientServer() throws Exception {
        InMemoryZKServer zkServer = InMemoryZKServer.builder().setDataDir(tmpFolder.newFolder()).build();
        zkServer.startAndWait();
        try {
            Configuration conf = new Configuration();
            conf.set("data.tx.zookeeper.quorum", zkServer.getConnectionStr());
            conf.set("data.tx.snapshot.dir", tmpFolder.newFolder().getAbsolutePath());
            final TransactionServiceMain main = new TransactionServiceMain(conf);
            final CountDownLatch latch = new CountDownLatch(1);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        main.start();
                        latch.countDown();
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            };
            try {
                t.start();
                latch.await();
                TransactionServiceClient.doMain((boolean)true, (Configuration)conf);
            }
            finally {
                main.stop();
                t.join();
            }
        }
        finally {
            zkServer.stopAndWait();
        }
    }
}

