/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionAware;
import co.cask.tephra.TransactionConflictException;
import co.cask.tephra.TransactionContext;
import co.cask.tephra.TransactionExecutor;
import co.cask.tephra.TransactionFailureException;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionNotInProgressException;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.inmemory.InMemoryTxSystemClient;
import co.cask.tephra.runtime.ConfigModule;
import co.cask.tephra.runtime.DiscoveryModules;
import co.cask.tephra.runtime.TransactionModules;
import co.cask.tephra.snapshot.DefaultSnapshotCodec;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.util.Modules;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TransactionContextTest {
    private static DummyTxClient txClient;
    @ClassRule
    public static TemporaryFolder tmpFolder;
    final DummyTxAware ds1 = new DummyTxAware();
    final DummyTxAware ds2 = new DummyTxAware();
    static final byte[] A;
    static final byte[] B;
    final TransactionExecutor.Function<Integer, Integer> testFunction = new TransactionExecutor.Function<Integer, Integer>(){

        public Integer apply(@Nullable Integer input) {
            TransactionContextTest.this.ds1.addChange(A);
            TransactionContextTest.this.ds2.addChange(B);
            if (input == null) {
                throw new RuntimeException("function failed");
            }
            return input * input;
        }
    };

    @BeforeClass
    public static void setup() throws IOException {
        final Configuration conf = new Configuration();
        conf.set("data.tx.snapshot.codecs", DefaultSnapshotCodec.class.getName());
        conf.set("data.tx.snapshot.dir", tmpFolder.newFolder().getAbsolutePath());
        Injector injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(conf), new DiscoveryModules().getInMemoryModules(), Modules.override((Module[])new Module[]{new TransactionModules().getInMemoryModules()}).with(new Module[]{new AbstractModule(){

            protected void configure() {
                TransactionManager txManager = new TransactionManager(conf);
                txManager.startAndWait();
                this.bind(TransactionManager.class).toInstance((Object)txManager);
                this.bind(TransactionSystemClient.class).to(DummyTxClient.class).in(Singleton.class);
            }
        }})});
        txClient = (DummyTxClient)((Object)injector.getInstance(TransactionSystemClient.class));
    }

    private static TransactionContext newTransactionContext(TransactionAware ... txAwares) {
        return new TransactionContext((TransactionSystemClient)txClient, txAwares);
    }

    @Before
    public void resetTxAwares() {
        this.ds1.reset();
        this.ds2.reset();
    }

    @Test
    public void testSuccessful() throws TransactionFailureException, InterruptedException {
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        context.finish();
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertTrue((boolean)this.ds2.committed);
        Assert.assertTrue((boolean)this.ds1.postCommitted);
        Assert.assertTrue((boolean)this.ds2.postCommitted);
        Assert.assertFalse((boolean)this.ds1.rolledBack);
        Assert.assertFalse((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Committed));
    }

    @Test
    public void testPostCommitFailure() throws TransactionFailureException, InterruptedException {
        this.ds1.failPostCommitTxOnce = InduceFailure.ThrowException;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"post commit failed - exception should be thrown");
        }
        catch (TransactionFailureException e) {
            Assert.assertEquals((Object)"post failure", (Object)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertTrue((boolean)this.ds2.committed);
        Assert.assertTrue((boolean)this.ds1.postCommitted);
        Assert.assertTrue((boolean)this.ds2.postCommitted);
        Assert.assertFalse((boolean)this.ds1.rolledBack);
        Assert.assertFalse((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Committed));
    }

    @Test
    public void testPersistFailure() throws TransactionFailureException, InterruptedException {
        this.ds1.failCommitTxOnce = InduceFailure.ThrowException;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"persist failed - exception should be thrown");
        }
        catch (TransactionFailureException e) {
            Assert.assertEquals((Object)"persist failure", (Object)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertFalse((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertTrue((boolean)this.ds1.rolledBack);
        Assert.assertTrue((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Aborted));
    }

    @Test
    public void testPersistFalse() throws TransactionFailureException, InterruptedException {
        this.ds1.failCommitTxOnce = InduceFailure.ReturnFalse;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"persist failed - exception should be thrown");
        }
        catch (TransactionFailureException e) {
            Assert.assertNull((Object)e.getCause());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertFalse((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertTrue((boolean)this.ds1.rolledBack);
        Assert.assertTrue((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Aborted));
    }

    @Test
    public void testPersistAndRollbackFailure() throws TransactionFailureException, InterruptedException {
        this.ds1.failCommitTxOnce = InduceFailure.ThrowException;
        this.ds1.failRollbackTxOnce = InduceFailure.ThrowException;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"persist failed - exception should be thrown");
        }
        catch (TransactionFailureException e) {
            Assert.assertEquals((Object)"persist failure", (Object)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertFalse((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertTrue((boolean)this.ds1.rolledBack);
        Assert.assertTrue((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Invalidated));
    }

    @Test
    public void testPersistAndRollbackFalse() throws TransactionFailureException, InterruptedException {
        this.ds1.failCommitTxOnce = InduceFailure.ReturnFalse;
        this.ds1.failRollbackTxOnce = InduceFailure.ReturnFalse;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"persist failed - exception should be thrown");
        }
        catch (TransactionFailureException e) {
            Assert.assertNull((Object)e.getCause());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertFalse((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertTrue((boolean)this.ds1.rolledBack);
        Assert.assertTrue((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Invalidated));
    }

    @Test
    public void testCommitFalse() throws TransactionFailureException, InterruptedException {
        TransactionContextTest.txClient.failCommits = 1;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"commit failed - exception should be thrown");
        }
        catch (TransactionConflictException e) {
            Assert.assertNull((Object)e.getCause());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertTrue((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertTrue((boolean)this.ds1.rolledBack);
        Assert.assertTrue((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Aborted));
    }

    @Test
    public void testCanCommitFalse() throws TransactionFailureException, InterruptedException {
        TransactionContextTest.txClient.failCanCommitOnce = true;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"commit failed - exception should be thrown");
        }
        catch (TransactionConflictException e) {
            Assert.assertNull((Object)e.getCause());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertFalse((boolean)this.ds1.committed);
        Assert.assertFalse((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertTrue((boolean)this.ds1.rolledBack);
        Assert.assertTrue((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Aborted));
    }

    @Test
    public void testChangesAndRollbackFailure() throws TransactionFailureException, InterruptedException {
        this.ds1.failChangesTxOnce = InduceFailure.ThrowException;
        this.ds1.failRollbackTxOnce = InduceFailure.ThrowException;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        context.start();
        this.ds1.addChange(A);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"get changes failed - exception should be thrown");
        }
        catch (TransactionFailureException e) {
            Assert.assertEquals((Object)"changes failure", (Object)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertFalse((boolean)this.ds2.checked);
        Assert.assertFalse((boolean)this.ds1.committed);
        Assert.assertFalse((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertTrue((boolean)this.ds1.rolledBack);
        Assert.assertTrue((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Invalidated));
    }

    @Test
    public void testStartAndRollbackFailure() throws TransactionFailureException, InterruptedException {
        this.ds1.failStartTxOnce = InduceFailure.ThrowException;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1, this.ds2);
        try {
            context.start();
            Assert.fail((String)"start failed - exception should be thrown");
        }
        catch (TransactionFailureException e) {
            Assert.assertEquals((Object)"start failure", (Object)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertFalse((boolean)this.ds2.started);
        Assert.assertFalse((boolean)this.ds1.checked);
        Assert.assertFalse((boolean)this.ds2.checked);
        Assert.assertFalse((boolean)this.ds1.committed);
        Assert.assertFalse((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertFalse((boolean)this.ds1.rolledBack);
        Assert.assertFalse((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Aborted));
    }

    @Test
    public void testAddThenSuccess() throws TransactionFailureException, InterruptedException {
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1);
        context.start();
        this.ds1.addChange(A);
        context.addTransactionAware((TransactionAware)this.ds2);
        this.ds2.addChange(B);
        context.finish();
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertTrue((boolean)this.ds2.committed);
        Assert.assertTrue((boolean)this.ds1.postCommitted);
        Assert.assertTrue((boolean)this.ds2.postCommitted);
        Assert.assertFalse((boolean)this.ds1.rolledBack);
        Assert.assertFalse((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Committed));
    }

    @Test
    public void testAddThenFailure() throws TransactionFailureException, InterruptedException {
        this.ds2.failCommitTxOnce = InduceFailure.ThrowException;
        TransactionContext context = TransactionContextTest.newTransactionContext(this.ds1);
        context.start();
        this.ds1.addChange(A);
        context.addTransactionAware((TransactionAware)this.ds2);
        this.ds2.addChange(B);
        try {
            context.finish();
            Assert.fail((String)"persist failed - exception should be thrown");
        }
        catch (TransactionFailureException e) {
            Assert.assertEquals((Object)"persist failure", (Object)e.getCause().getMessage());
        }
        Assert.assertTrue((boolean)this.ds1.started);
        Assert.assertTrue((boolean)this.ds2.started);
        Assert.assertTrue((boolean)this.ds1.checked);
        Assert.assertTrue((boolean)this.ds2.checked);
        Assert.assertTrue((boolean)this.ds1.committed);
        Assert.assertTrue((boolean)this.ds2.committed);
        Assert.assertFalse((boolean)this.ds1.postCommitted);
        Assert.assertFalse((boolean)this.ds2.postCommitted);
        Assert.assertTrue((boolean)this.ds1.rolledBack);
        Assert.assertTrue((boolean)this.ds2.rolledBack);
        Assert.assertEquals((Object)((Object)TransactionContextTest.txClient.state), (Object)((Object)DummyTxClient.CommitState.Aborted));
    }

    static {
        tmpFolder = new TemporaryFolder();
        A = new byte[]{97};
        B = new byte[]{98};
    }

    static class DummyTxClient
    extends InMemoryTxSystemClient {
        boolean failCanCommitOnce = false;
        int failCommits = 0;
        CommitState state = CommitState.Started;

        @Inject
        DummyTxClient(TransactionManager txmgr) {
            super(txmgr);
        }

        public boolean canCommit(Transaction tx, Collection<byte[]> changeIds) throws TransactionNotInProgressException {
            if (this.failCanCommitOnce) {
                this.failCanCommitOnce = false;
                return false;
            }
            return super.canCommit(tx, changeIds);
        }

        public boolean commit(Transaction tx) throws TransactionNotInProgressException {
            if (this.failCommits-- > 0) {
                return false;
            }
            this.state = CommitState.Committed;
            return super.commit(tx);
        }

        public Transaction startLong() {
            this.state = CommitState.Started;
            return super.startLong();
        }

        public Transaction startShort() {
            this.state = CommitState.Started;
            return super.startShort();
        }

        public Transaction startShort(int timeout) {
            this.state = CommitState.Started;
            return super.startShort(timeout);
        }

        public void abort(Transaction tx) {
            this.state = CommitState.Aborted;
            super.abort(tx);
        }

        public boolean invalidate(long tx) {
            this.state = CommitState.Invalidated;
            return super.invalidate(tx);
        }

        static enum CommitState {
            Started,
            Committed,
            Aborted,
            Invalidated;

        }
    }

    static class DummyTxAware
    implements TransactionAware {
        Transaction tx;
        boolean started = false;
        boolean committed = false;
        boolean checked = false;
        boolean rolledBack = false;
        boolean postCommitted = false;
        List<byte[]> changes = Lists.newArrayList();
        InduceFailure failStartTxOnce = InduceFailure.NoFailure;
        InduceFailure failChangesTxOnce = InduceFailure.NoFailure;
        InduceFailure failCommitTxOnce = InduceFailure.NoFailure;
        InduceFailure failPostCommitTxOnce = InduceFailure.NoFailure;
        InduceFailure failRollbackTxOnce = InduceFailure.NoFailure;

        DummyTxAware() {
        }

        void addChange(byte[] key) {
            this.changes.add(key);
        }

        void reset() {
            this.tx = null;
            this.started = false;
            this.checked = false;
            this.committed = false;
            this.rolledBack = false;
            this.postCommitted = false;
            this.changes.clear();
        }

        public void startTx(Transaction tx) {
            this.reset();
            this.started = true;
            this.tx = tx;
            if (this.failStartTxOnce == InduceFailure.ThrowException) {
                this.failStartTxOnce = InduceFailure.NoFailure;
                throw new RuntimeException("start failure");
            }
        }

        public Collection<byte[]> getTxChanges() {
            this.checked = true;
            if (this.failChangesTxOnce == InduceFailure.ThrowException) {
                this.failChangesTxOnce = InduceFailure.NoFailure;
                throw new RuntimeException("changes failure");
            }
            return ImmutableList.copyOf(this.changes);
        }

        public boolean commitTx() throws Exception {
            this.committed = true;
            if (this.failCommitTxOnce == InduceFailure.ThrowException) {
                this.failCommitTxOnce = InduceFailure.NoFailure;
                throw new RuntimeException("persist failure");
            }
            if (this.failCommitTxOnce == InduceFailure.ReturnFalse) {
                this.failCommitTxOnce = InduceFailure.NoFailure;
                return false;
            }
            return true;
        }

        public void postTxCommit() {
            this.postCommitted = true;
            if (this.failPostCommitTxOnce == InduceFailure.ThrowException) {
                this.failPostCommitTxOnce = InduceFailure.NoFailure;
                throw new RuntimeException("post failure");
            }
        }

        public boolean rollbackTx() throws Exception {
            this.rolledBack = true;
            if (this.failRollbackTxOnce == InduceFailure.ThrowException) {
                this.failRollbackTxOnce = InduceFailure.NoFailure;
                throw new RuntimeException("rollback failure");
            }
            if (this.failRollbackTxOnce == InduceFailure.ReturnFalse) {
                this.failRollbackTxOnce = InduceFailure.NoFailure;
                return false;
            }
            return true;
        }

        public String getTransactionAwareName() {
            return "dummy";
        }
    }

    static enum InduceFailure {
        NoFailure,
        ReturnFalse,
        ThrowException;

    }
}

