/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.ChangeId;
import co.cask.tephra.persist.TransactionEdit;
import com.google.common.collect.Sets;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class TransactionEditTest {
    @Test
    public void testV1SerdeCompat() throws Exception {
        this.verifyDecodingSupportsV1(TransactionEdit.createStarted((long)2L, (long)0L, (long)1000L));
        this.verifyDecodingSupportsV1(TransactionEdit.createCommitted((long)2L, (Set)Sets.newHashSet((Object[])new ChangeId[]{new ChangeId(Bytes.toBytes((String)"c"))}), (long)3L, (boolean)true));
    }

    private void verifyDecodingSupportsV1(TransactionEdit edit) throws IOException {
        TransactionEdit.TransactionEditCodecV1 v1Codec = new TransactionEdit.TransactionEditCodecV1();
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        v1Codec.encode(edit, (DataOutput)out);
        TransactionEdit decodedEdit = new TransactionEdit();
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])out.toByteArray());
        decodedEdit.readFields((DataInput)in);
        Assert.assertEquals((Object)edit, (Object)decodedEdit);
    }
}

