/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.persist;

import co.cask.tephra.persist.AbstractTransactionStateStorage;
import co.cask.tephra.persist.AbstractTransactionStateStorageTest;
import co.cask.tephra.persist.LocalFileTransactionStateStorage;
import co.cask.tephra.snapshot.DefaultSnapshotCodec;
import co.cask.tephra.snapshot.SnapshotCodecProvider;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class LocalTransactionStateStorageTest
extends AbstractTransactionStateStorageTest {
    @ClassRule
    public static TemporaryFolder tmpDir = new TemporaryFolder();

    @Override
    protected Configuration getConfiguration(String testName) throws IOException {
        File testDir = tmpDir.newFolder(testName);
        Configuration conf = HBaseConfiguration.create();
        conf.set("data.tx.snapshot.local.dir", testDir.getAbsolutePath());
        conf.set("data.tx.snapshot.codecs", DefaultSnapshotCodec.class.getName());
        return conf;
    }

    @Override
    protected AbstractTransactionStateStorage getStorage(Configuration conf) {
        return new LocalFileTransactionStateStorage(conf, new SnapshotCodecProvider(conf));
    }
}

