/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionNotInProgressException;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.persist.TransactionSnapshot;
import co.cask.tephra.persist.TransactionStateStorage;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public abstract class TransactionSystemTest {
    public static final byte[] C1 = Bytes.toBytes((String)"change1");
    public static final byte[] C2 = Bytes.toBytes((String)"change2");
    public static final byte[] C3 = Bytes.toBytes((String)"change3");
    public static final byte[] C4 = Bytes.toBytes((String)"change4");

    protected abstract TransactionSystemClient getClient() throws Exception;

    protected abstract TransactionStateStorage getStateStorage() throws Exception;

    @Test
    public void testCommitRaceHandling() throws Exception {
        TransactionSystemClient client1 = this.getClient();
        TransactionSystemClient client2 = this.getClient();
        Transaction tx1 = client1.startShort();
        Transaction tx2 = client2.startShort();
        Assert.assertTrue((boolean)client1.canCommit(tx1, this.asList(C1, C2)));
        Assert.assertTrue((boolean)client2.canCommit(tx2, this.asList(C2, C3)));
        Assert.assertTrue((boolean)client1.commit(tx1));
        Assert.assertFalse((boolean)client2.commit(tx2));
    }

    @Test
    public void testMultipleCommitsAtSameTime() throws Exception {
        TransactionSystemClient client1 = this.getClient();
        TransactionSystemClient client2 = this.getClient();
        TransactionSystemClient client3 = this.getClient();
        TransactionSystemClient client4 = this.getClient();
        TransactionSystemClient client5 = this.getClient();
        Transaction tx1 = client1.startShort();
        Transaction tx2 = client2.startShort();
        Transaction tx3 = client3.startShort();
        Transaction tx4 = client4.startShort();
        Transaction tx5 = client5.startShort();
        Assert.assertTrue((boolean)client1.canCommit(tx1, this.asList(new byte[][]{C1})));
        Assert.assertTrue((boolean)client1.commit(tx1));
        Assert.assertTrue((boolean)client2.canCommit(tx2, this.asList(new byte[][]{C2})));
        Assert.assertTrue((boolean)client2.commit(tx2));
        Assert.assertFalse((boolean)client3.canCommit(tx3, this.asList(new byte[][]{C1})));
        Assert.assertFalse((boolean)client4.canCommit(tx4, this.asList(new byte[][]{C2})));
        Assert.assertTrue((boolean)client5.canCommit(tx5, this.asList(new byte[][]{C3})));
    }

    @Test
    public void testCommitTwice() throws Exception {
        TransactionSystemClient client = this.getClient();
        Transaction tx = client.startShort();
        Assert.assertTrue((boolean)client.canCommit(tx, this.asList(C1, C2)));
        Assert.assertTrue((boolean)client.commit(tx));
        try {
            Assert.assertFalse((boolean)client.commit(tx));
            Assert.fail();
        }
        catch (TransactionNotInProgressException transactionNotInProgressException) {
            // empty catch block
        }
    }

    @Test
    public void testAbortTwice() throws Exception {
        TransactionSystemClient client = this.getClient();
        Transaction tx = client.startShort();
        Assert.assertTrue((boolean)client.canCommit(tx, this.asList(C1, C2)));
        client.abort(tx);
        client.abort(tx);
    }

    @Test
    public void testReuseTx() throws Exception {
        TransactionSystemClient client = this.getClient();
        Transaction tx = client.startShort();
        Assert.assertTrue((boolean)client.canCommit(tx, this.asList(C1, C2)));
        Assert.assertTrue((boolean)client.commit(tx));
        try {
            client.canCommit(tx, this.asList(C3, C4));
            Assert.fail();
        }
        catch (TransactionNotInProgressException e) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)client.commit(tx));
            Assert.fail();
        }
        catch (TransactionNotInProgressException transactionNotInProgressException) {
            // empty catch block
        }
        client.abort(tx);
    }

    @Test
    public void testUseNotStarted() throws Exception {
        TransactionSystemClient client = this.getClient();
        Transaction tx1 = client.startShort();
        Assert.assertTrue((boolean)client.commit(tx1));
        Transaction txOld = new Transaction(tx1.getReadPointer(), tx1.getWritePointer() - 1L, new long[0], new long[0], Long.MAX_VALUE);
        try {
            Assert.assertFalse((boolean)client.canCommit(txOld, this.asList(C3, C4)));
            Assert.fail();
        }
        catch (TransactionNotInProgressException e) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)client.commit(txOld));
            Assert.fail();
        }
        catch (TransactionNotInProgressException e) {
            // empty catch block
        }
        client.abort(txOld);
        Transaction txNew = new Transaction(tx1.getReadPointer(), tx1.getWritePointer() + 1L, new long[0], new long[0], Long.MAX_VALUE);
        try {
            Assert.assertFalse((boolean)client.canCommit(txNew, this.asList(C3, C4)));
            Assert.fail();
        }
        catch (TransactionNotInProgressException e) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)client.commit(txNew));
            Assert.fail();
        }
        catch (TransactionNotInProgressException e) {
            // empty catch block
        }
        client.abort(txNew);
    }

    @Test
    public void testAbortAfterCommit() throws Exception {
        TransactionSystemClient client = this.getClient();
        Transaction tx = client.startShort();
        Assert.assertTrue((boolean)client.canCommit(tx, this.asList(C1, C2)));
        Assert.assertTrue((boolean)client.commit(tx));
        client.abort(tx);
    }

    @Test
    public void testInvalidateTx() throws Exception {
        TransactionSystemClient client = this.getClient();
        Transaction tx1 = client.startShort();
        client.canCommit(tx1, this.asList(C1, C2));
        Assert.assertTrue((boolean)client.invalidate(tx1.getWritePointer()));
        Transaction tx2 = client.startShort();
        client.canCommit(tx2, this.asList(C3, C4));
        client.commit(tx2);
        Assert.assertFalse((boolean)client.invalidate(tx2.getWritePointer()));
    }

    @Test
    public void testResetState() throws Exception {
        TransactionSystemClient client = this.getClient();
        TransactionStateStorage stateStorage = this.getStateStorage();
        Transaction tx1 = client.startShort();
        Transaction tx2 = client.startShort();
        client.canCommit(tx1, this.asList(C1, C2));
        client.commit(tx1);
        client.canCommit(tx2, this.asList(C3, C4));
        Transaction txPreReset = client.startShort();
        long currentTs = System.currentTimeMillis();
        client.resetState();
        TransactionSnapshot snapshot = stateStorage.getLatestSnapshot();
        Assert.assertTrue((snapshot.getTimestamp() >= currentTs ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)snapshot.getInvalid().size());
        Assert.assertEquals((long)0L, (long)snapshot.getInProgress().size());
        Assert.assertEquals((long)0L, (long)snapshot.getCommittingChangeSets().size());
        Assert.assertEquals((long)0L, (long)snapshot.getCommittedChangeSets().size());
        Transaction txPostReset = client.startShort();
        Assert.assertTrue((String)"New tx ID should be greater than last ID before reset", (txPostReset.getWritePointer() > txPreReset.getWritePointer() ? 1 : 0) != 0);
    }

    private Collection<byte[]> asList(byte[] ... val) {
        return Arrays.asList(val);
    }
}

