/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionNotInProgressException;
import co.cask.tephra.TransactionSystemClient;
import co.cask.tephra.TransactionSystemTest;
import co.cask.tephra.inmemory.InMemoryTxSystemClient;
import co.cask.tephra.metrics.TxMetricsCollector;
import co.cask.tephra.persist.InMemoryTransactionStateStorage;
import co.cask.tephra.persist.TransactionStateStorage;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionManagerTest
extends TransactionSystemTest {
    static Configuration conf = HBaseConfiguration.create();
    TransactionManager txManager = null;
    TransactionStateStorage txStateStorage = null;

    @Override
    protected TransactionSystemClient getClient() {
        return new InMemoryTxSystemClient(this.txManager);
    }

    @Override
    protected TransactionStateStorage getStateStorage() {
        return this.txStateStorage;
    }

    @Before
    public void before() {
        conf.setInt("data.tx.cleanup.interval", 0);
        this.txStateStorage = new InMemoryTransactionStateStorage();
        this.txManager = new TransactionManager(conf, this.txStateStorage, new TxMetricsCollector());
        this.txManager.startAndWait();
    }

    @After
    public void after() {
        this.txManager.stopAndWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionCleanup() throws Exception {
        conf.setInt("data.tx.cleanup.interval", 3);
        conf.setInt("data.tx.timeout", 2);
        TransactionManager txm = new TransactionManager(conf, (TransactionStateStorage)new InMemoryTransactionStateStorage(), new TxMetricsCollector());
        txm.startAndWait();
        try {
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            Transaction tx1 = txm.startShort();
            Transaction tx2 = txm.startLong();
            Transaction tx3 = txm.startLong();
            for (int i = 0; i < 10; ++i) {
                Transaction tx = txm.startShort();
                Assert.assertTrue((boolean)txm.canCommit(tx, Collections.singleton(new byte[]{(byte)i})));
                Assert.assertTrue((boolean)txm.commit(tx));
            }
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)10L, (long)txm.getCommittedSize());
            TimeUnit.SECONDS.sleep(5L);
            Assert.assertEquals((long)1L, (long)txm.getInvalidSize());
            Transaction txx = txm.startShort();
            Assert.assertFalse((boolean)txx.isVisible(tx1.getWritePointer()));
            Assert.assertFalse((boolean)txx.isVisible(tx2.getWritePointer()));
            Assert.assertFalse((boolean)txx.isVisible(tx3.getWritePointer()));
            Assert.assertTrue((boolean)txm.canCommit(txx, Collections.singleton(new byte[]{10})));
            Assert.assertTrue((boolean)txm.commit(txx));
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            try {
                txm.canCommit(tx1, Collections.singleton(new byte[]{17}));
                Assert.fail();
            }
            catch (TransactionNotInProgressException e) {
                // empty catch block
            }
            txm.abort(tx1);
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            for (int i = 0; i < 10; ++i) {
                Transaction tx = txm.startShort();
                Assert.assertTrue((boolean)txm.canCommit(tx, Collections.singleton(new byte[]{(byte)i})));
                Assert.assertTrue((boolean)txm.commit(tx));
            }
            Assert.assertEquals((long)0L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)0L, (long)txm.getCommittedSize());
            Assert.assertTrue((boolean)txm.commit(tx2));
            txm.abort(tx3);
            Assert.assertEquals((long)1L, (long)txm.getInvalidSize());
            Assert.assertEquals((long)tx3.getWritePointer(), (long)((Long)txm.getCurrentState().getInvalid().iterator().next()));
            Assert.assertEquals((long)1L, (long)txm.getExcludedListSize());
        }
        finally {
            txm.stopAndWait();
        }
    }
}

