/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.spec;

import co.cask.mmds.spec.Param;
import co.cask.mmds.spec.ParamSpec;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class IntArrayParam
extends Param<int[]> {
    private final ParamSpec spec;

    public IntArrayParam(String name, String label, String description, int[] defaultVal, Map<String, String> params) {
        super(name, description, defaultVal, params);
        StringBuilder defaultStr = new StringBuilder();
        if (defaultVal.length > 0) {
            defaultStr.append(defaultVal[0]);
        }
        for (int i = 1; i < defaultVal.length; ++i) {
            defaultStr.append(',').append(defaultVal[i]);
        }
        this.spec = new ParamSpec("intarray", name, label, description, defaultStr.toString(), null, null);
    }

    @Override
    protected int[] parseVal(String strVal) {
        String[] parts = strVal.split(",");
        int[] layers = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String trimmed = parts[i].trim();
            try {
                int layer = Integer.parseInt(trimmed);
                if (layer < 1) {
                    throw new IllegalArgumentException(String.format("Invalid modeler parameter %s=%s. Must be a comma separate list of positive integers.", this.name, strVal));
                }
                layers[i] = layer;
                continue;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException(String.format("Invalid modeler parameter %s=%s. Must be a comma separate list of positive integers.", this.name, strVal));
            }
        }
        return layers;
    }

    @Override
    public ParamSpec getSpec() {
        return this.spec;
    }

    @Override
    public String getValStr() {
        return Arrays.stream((int[])this.getVal()).boxed().map(x -> Integer.toString(x)).collect(Collectors.joining(","));
    }
}

