/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.data;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.mmds.data.ColumnSplitStats;
import co.cask.mmds.data.DataSplit;
import co.cask.mmds.data.SplitStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class DataSplitStats
extends DataSplit {
    private final String id;
    private final String trainingPath;
    private final String testPath;
    private final SplitStatus status;
    private final List<ColumnSplitStats> stats;
    private final Set<String> models;
    private final long start;
    private final long end;

    public DataSplitStats(String id, String description, String type, Map<String, String> params, List<String> directives, Schema schema, String trainingPath, String testPath, SplitStatus status, List<ColumnSplitStats> stats, Set<String> models, long start, long end) {
        super(description, type, params, directives, schema);
        this.id = id;
        this.trainingPath = trainingPath;
        this.testPath = testPath;
        this.status = status;
        this.stats = stats;
        this.models = Collections.unmodifiableSet(models);
        this.start = start;
        this.end = end;
    }

    public String getId() {
        return this.id;
    }

    public SplitStatus getStatus() {
        return this.status;
    }

    @Nullable
    public String getTrainingPath() {
        return this.trainingPath;
    }

    @Nullable
    public String getTestPath() {
        return this.testPath;
    }

    public List<ColumnSplitStats> getStats() {
        return this.stats;
    }

    public Set<String> getModels() {
        return this.models;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataSplitStats that = (DataSplitStats)o;
        return this.start == that.start && this.end == that.end && Objects.equals(this.id, that.id) && Objects.equals(this.trainingPath, that.trainingPath) && Objects.equals(this.testPath, that.testPath) && this.status == that.status && Objects.equals(this.stats, that.stats) && Objects.equals(this.models, that.models);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.id, this.trainingPath, this.testPath, this.status, this.stats, this.models, this.start, this.end});
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public String toString() {
        return "DataSplitStats{id='" + this.id + '\'' + ", trainingPath='" + this.trainingPath + '\'' + ", testPath='" + this.testPath + '\'' + ", status=" + (Object)((Object)this.status) + ", stats=" + this.stats + ", models=" + this.models + ", start=" + this.start + ", end=" + this.end + '}';
    }

    public static class Builder
    extends DataSplit.Builder<Builder> {
        private final String id;
        private String trainingPath;
        private String testPath;
        private SplitStatus status;
        private List<ColumnSplitStats> stats;
        private Set<String> models;
        private long start;
        private long end;

        public Builder(String id) {
            this.id = id;
            this.models = new HashSet<String>();
            this.stats = new ArrayList<ColumnSplitStats>();
            this.start = -1L;
            this.end = -1L;
        }

        public Builder setTrainingPath(String trainingPath) {
            this.trainingPath = trainingPath;
            return this;
        }

        public Builder setTestPath(String testPath) {
            this.testPath = testPath;
            return this;
        }

        public Builder setStats(List<ColumnSplitStats> stats) {
            this.stats.clear();
            this.stats.addAll(stats);
            return this;
        }

        public Builder setModels(Set<String> models) {
            this.models.clear();
            this.models.addAll(models);
            return this;
        }

        public Builder setStatus(SplitStatus status) {
            this.status = status;
            return this;
        }

        public Builder setStartTime(long startMillis) {
            this.start = startMillis;
            return this;
        }

        public Builder setEndTime(long endMillis) {
            this.end = endMillis;
            return this;
        }

        @Override
        public DataSplitStats build() {
            DataSplitStats splitStats = new DataSplitStats(this.id, this.description, this.type, this.params, this.directives, this.schema, this.trainingPath, this.testPath, this.status, this.stats, this.models, this.start, this.end);
            splitStats.validate();
            return splitStats;
        }
    }
}

