/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.data.schema.UnsupportedTypeException;
import java.util.Iterator;
import java.util.Map;

public final class Schemas {
    private Schemas() {
    }

    public static String toHiveSchema(Schema schema) throws UnsupportedTypeException {
        if (schema.getType() != Schema.Type.RECORD || schema.getFields().size() < 1) {
            throw new UnsupportedTypeException("Schema must be of getType record and have at least one field.");
        }
        StringBuilder builder = new StringBuilder();
        Iterator fieldIter = schema.getFields().iterator();
        Schemas.appendField(builder, (Schema.Field)fieldIter.next(), false);
        while (fieldIter.hasNext()) {
            builder.append(", ");
            Schemas.appendField(builder, (Schema.Field)fieldIter.next(), false);
        }
        return builder.toString();
    }

    public static void appendType(StringBuilder builder, Schema schema) throws UnsupportedTypeException {
        switch (schema.getType()) {
            case NULL: {
                break;
            }
            case ENUM: {
                builder.append("string");
                break;
            }
            case BOOLEAN: {
                builder.append("boolean");
                break;
            }
            case INT: {
                builder.append("int");
                break;
            }
            case LONG: {
                builder.append("bigint");
                break;
            }
            case FLOAT: {
                builder.append("float");
                break;
            }
            case DOUBLE: {
                builder.append("double");
                break;
            }
            case BYTES: {
                builder.append("binary");
                break;
            }
            case STRING: {
                builder.append("string");
                break;
            }
            case ARRAY: {
                builder.append("array<");
                Schemas.appendType(builder, schema.getComponentSchema());
                builder.append(">");
                break;
            }
            case MAP: {
                builder.append("map<");
                Map.Entry mapSchema = schema.getMapSchema();
                Schemas.appendType(builder, (Schema)mapSchema.getKey());
                builder.append(",");
                Schemas.appendType(builder, (Schema)mapSchema.getValue());
                builder.append(">");
                break;
            }
            case RECORD: {
                builder.append("struct<");
                Iterator fieldIter = schema.getFields().iterator();
                Schemas.appendField(builder, (Schema.Field)fieldIter.next(), true);
                while (fieldIter.hasNext()) {
                    builder.append(",");
                    Schemas.appendField(builder, (Schema.Field)fieldIter.next(), true);
                }
                builder.append(">");
                break;
            }
            case UNION: {
                if (schema.isNullable()) {
                    Schemas.appendType(builder, schema.getNonNullable());
                    break;
                }
                throw new UnsupportedTypeException("Unions are currently not supported");
            }
        }
    }

    private static void appendField(StringBuilder builder, Schema.Field field, boolean inStruct) throws UnsupportedTypeException {
        String name = field.getName();
        builder.append('`');
        builder.append(name);
        builder.append('`');
        builder.append(inStruct ? ":" : " ");
        Schemas.appendType(builder, field.getSchema());
    }
}

