/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.stats;

import java.io.Serializable;

public class NumericStats
implements Serializable {
    private static final long serialVersionUID = 6770304235190586763L;
    private Double min;
    private Double max;
    private long count;
    private long nullCount;

    public NumericStats(Double val) {
        this(val, val, 1L, val == null ? 1L : 0L);
    }

    private NumericStats(Double min, Double max, long count, long nullCount) {
        this.min = min;
        this.max = max;
        this.count = count;
        this.nullCount = nullCount;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public long getCount() {
        return this.count;
    }

    public long getNullCount() {
        return this.nullCount;
    }

    public void update(Double val) {
        ++this.count;
        if (val == null) {
            ++this.nullCount;
            return;
        }
        this.min = this.min == null ? val : Double.valueOf(Math.min(this.min, val));
        this.max = this.max == null ? val : Double.valueOf(Math.max(this.max, val));
    }

    public NumericStats merge(NumericStats other) {
        Double newMin = this.min != null && other.min != null ? Double.valueOf(Math.min(this.min, other.min)) : (this.min == null ? other.min : this.min);
        Double newMax = this.max != null && other.max != null ? Double.valueOf(Math.max(this.max, other.max)) : (this.max == null ? other.max : this.max);
        return new NumericStats(newMin, newMax, this.count + other.count, this.nullCount + other.nullCount);
    }
}

