/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.stats;

import co.cask.mmds.NullableMath;
import co.cask.mmds.stats.Histogram;
import co.cask.mmds.stats.NumericBin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class NumericHisto
extends Histogram<NumericHisto>
implements Serializable {
    private static final long serialVersionUID = 6989232047290418068L;
    private final List<NumericBin> bins;
    private Double min;
    private Double max;
    private Double mean;
    private Double m2;
    private long zeroCount;
    private long negativeCount;
    private long positiveCount;

    public NumericHisto(double min, double max, int maxBins, Double val) {
        super(0L, 0L);
        this.min = val;
        this.max = val;
        this.bins = new ArrayList<NumericBin>();
        this.zeroCount = 0L;
        this.negativeCount = 0L;
        this.positiveCount = 0L;
        this.mean = null;
        this.m2 = null;
        if (min == max) {
            NumericBin bin = new NumericBin(min, max, 0L, true);
            this.bins.add(bin);
            this.update(val);
            return;
        }
        double roundedMin = this.round(min, 2, Math::floor);
        double step = this.round((max - roundedMin) / (double)maxBins, 1, Math::ceil);
        double lo = roundedMin;
        double hi = roundedMin + step;
        int numBins = 1;
        while (lo < max) {
            hi = numBins == maxBins ? Math.max(hi, max) : hi;
            NumericBin bin = new NumericBin(lo, hi, 0L, hi >= max);
            this.bins.add(bin);
            lo = hi;
            hi += step;
            ++numBins;
        }
        this.update(val);
    }

    private NumericHisto(long totalCount, long nullCount, List<NumericBin> bins, Double min, Double max, Double mean, Double m2, Long zeroCount, Long negativeCount, Long positiveCount) {
        super(totalCount, nullCount);
        this.bins = bins;
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.m2 = m2;
        this.zeroCount = zeroCount;
        this.negativeCount = negativeCount;
        this.positiveCount = positiveCount;
    }

    private double round(double x, int n, Function<Double, Double> rounder) {
        if (x == 0.0) {
            return x;
        }
        int multiplier = 1;
        if (x < 0.0) {
            multiplier = -1;
            x = 0.0 - x;
        }
        double exponent = Math.floor(Math.log10(x));
        double power = Math.pow(10.0, exponent - (double)n + 1.0);
        double scaled = x / power;
        double rounded = rounder.apply(scaled);
        return (double)multiplier * rounded * power;
    }

    public List<NumericBin> getBins() {
        return this.bins;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getMean() {
        return this.mean;
    }

    public Double getM2() {
        return this.m2;
    }

    public Double getStddev() {
        return this.m2 == null ? null : Double.valueOf(Math.sqrt(this.m2 / (double)(this.totalCount - this.nullCount)));
    }

    public long getZeroCount() {
        return this.zeroCount;
    }

    public long getNegativeCount() {
        return this.negativeCount;
    }

    public long getPositiveCount() {
        return this.positiveCount;
    }

    public void update(Double val) {
        ++this.totalCount;
        if (val == null) {
            ++this.nullCount;
            return;
        }
        this.min = NullableMath.min(this.min, val);
        this.max = NullableMath.max(this.max, val);
        if (val == 0.0) {
            ++this.zeroCount;
        } else if (val > 0.0) {
            ++this.positiveCount;
        } else {
            ++this.negativeCount;
        }
        if (this.mean == null) {
            this.mean = val;
            this.m2 = 0.0;
        } else {
            long numNonNull = this.totalCount - this.nullCount;
            double delta = val - this.mean;
            this.mean = this.mean + delta / (double)numNonNull;
            double delta2 = val - this.mean;
            this.m2 = this.m2 + delta * delta2;
        }
        for (NumericBin bin : this.bins) {
            if (!bin.incrementIfInBin(val)) continue;
            return;
        }
    }

    @Override
    public NumericHisto merge(NumericHisto other) {
        ArrayList<NumericBin> merged = new ArrayList<NumericBin>(this.bins.size());
        Iterator<NumericBin> h1Iter = this.bins.iterator();
        Iterator<NumericBin> h2Iter = other.bins.iterator();
        while (h1Iter.hasNext()) {
            merged.add(h1Iter.next().merge(h2Iter.next()));
        }
        Double newMin = NullableMath.min(this.min, other.min);
        Double newMax = NullableMath.max(this.max, other.max);
        long newTotalCount = this.totalCount + other.totalCount;
        long newNullCount = this.nullCount + other.nullCount;
        long newZeroCount = this.zeroCount + other.zeroCount;
        long newPositiveCount = this.positiveCount + other.positiveCount;
        long newNegativeCount = this.negativeCount + other.negativeCount;
        long nonNullCount = this.totalCount - this.nullCount;
        long otherNonNullCount = other.totalCount - other.nullCount;
        Double newMean = NullableMath.mean(this.mean, nonNullCount, other.mean, otherNonNullCount);
        Double newM2 = NullableMath.m2(this.m2, this.mean, nonNullCount, other.m2, other.mean, otherNonNullCount);
        return new NumericHisto(newTotalCount, newNullCount, merged, newMin, newMax, newMean, newM2, newZeroCount, newNegativeCount, newPositiveCount);
    }

    private double square(double x) {
        return x * x;
    }
}

