/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.proto;

import co.cask.mmds.api.Modeler;
import co.cask.mmds.modeler.Modelers;
import co.cask.mmds.proto.BadRequestException;
import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class TrainModelRequest {
    private final String algorithm;
    private final String predictionsDataset;
    private final Map<String, String> hyperparameters;

    public TrainModelRequest(String algorithm, String predictionsDataset, Map<String, String> hyperparameters) {
        this.algorithm = algorithm;
        this.predictionsDataset = predictionsDataset;
        this.hyperparameters = hyperparameters;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Nullable
    public String getPredictionsDataset() {
        return this.predictionsDataset;
    }

    public Map<String, String> getHyperparameters() {
        return Collections.unmodifiableMap(this.hyperparameters == null ? new HashMap() : this.hyperparameters);
    }

    public void validate() {
        if (this.algorithm == null || this.algorithm.isEmpty()) {
            throw new BadRequestException("Must specify a name");
        }
        Modeler modeler = Modelers.getModeler(this.algorithm);
        if (modeler == null) {
            throw new BadRequestException(String.format("No modeler found for algorithm '%s'. Must be one of '%s'", this.algorithm, Joiner.on((char)',').join(Modelers.getAlgorithms())));
        }
    }
}

