/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.data;

import co.cask.mmds.data.EvaluationMetrics;
import co.cask.mmds.data.Model;
import co.cask.mmds.data.ModelStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class ModelMeta
extends Model {
    private final String id;
    private final long createtime;
    private final long trainingtime;
    private final long trainedtime;
    private final long deploytime;
    private final ModelStatus status;
    private final String outcome;
    private final List<String> features;
    private final Set<String> categoricalFeatures;
    private final EvaluationMetrics evaluationMetrics;

    private ModelMeta(String id, String name, String description, String algorithm, String split, @Nullable String predictionsDataset, ModelStatus status, List<String> directives, Map<String, String> hyperparameters, List<String> features, String outcome, Set<String> categoricalFeatures, long createtime, long trainingtime, long trainedtime, Long deploytime, EvaluationMetrics evaluationMetrics) {
        super(name, description, algorithm, split, predictionsDataset, directives, hyperparameters);
        this.id = id;
        this.status = status;
        this.outcome = outcome;
        this.features = Collections.unmodifiableList(features);
        this.categoricalFeatures = Collections.unmodifiableSet(categoricalFeatures);
        this.createtime = createtime;
        this.trainingtime = trainingtime;
        this.trainedtime = trainedtime;
        this.deploytime = deploytime;
        this.evaluationMetrics = evaluationMetrics;
    }

    public String getId() {
        return this.id;
    }

    public ModelStatus getStatus() {
        return this.status;
    }

    public EvaluationMetrics getEvaluationMetrics() {
        return this.evaluationMetrics;
    }

    public long getCreatetime() {
        return this.createtime;
    }

    public long getTrainingtime() {
        return this.trainingtime;
    }

    public long getTrainedtime() {
        return this.trainedtime;
    }

    public long getDeploytime() {
        return this.deploytime;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public Set<String> getCategoricalFeatures() {
        return this.categoricalFeatures;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelMeta that = (ModelMeta)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.createtime, that.createtime) && Objects.equals(this.trainedtime, that.trainedtime) && Objects.equals(this.deploytime, that.deploytime) && Objects.equals((Object)this.status, (Object)that.status) && Objects.equals(this.outcome, that.outcome) && Objects.equals(this.categoricalFeatures, that.categoricalFeatures) && Objects.equals(this.evaluationMetrics, that.evaluationMetrics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createtime, this.trainedtime, this.deploytime, this.status, this.outcome, this.categoricalFeatures, this.evaluationMetrics});
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public static Builder builder(ModelMeta meta) {
        return new Builder(meta.id).setCreateTime(meta.createtime).setTrainingTime(meta.trainingtime).setTrainedTime(meta.trainedtime).setDeployTime(meta.deploytime).setOutcome(meta.outcome).setStatus(meta.status).setFeatures(meta.features).setCategoricalFeatures(meta.categoricalFeatures).setEvaluationMetrics(meta.evaluationMetrics);
    }

    public static class Builder
    extends Model.Builder<Builder> {
        private final String id;
        private long createtime;
        private long trainingtime;
        private long trainedtime;
        private long deploytime;
        private String outcome;
        private ModelStatus status;
        protected List<String> features;
        private Set<String> categoricalFeatures;
        private EvaluationMetrics evaluationMetrics;

        public Builder(String id) {
            this.id = id;
            this.features = new ArrayList<String>();
            this.categoricalFeatures = new HashSet<String>();
            this.trainingtime = -1L;
            this.trainedtime = -1L;
            this.deploytime = -1L;
            this.evaluationMetrics = new EvaluationMetrics(null, null, null, null, null, null, null);
        }

        public Builder setCreateTime(long createTime) {
            this.createtime = createTime;
            return this;
        }

        public Builder setDeployTime(long deployTime) {
            this.deploytime = deployTime;
            return this;
        }

        public Builder setTrainingTime(long trainingTime) {
            this.trainingtime = trainingTime;
            return this;
        }

        public Builder setTrainedTime(long trainedTime) {
            this.trainedtime = trainedTime;
            return this;
        }

        public Builder setOutcome(String outcome) {
            this.outcome = outcome;
            return this;
        }

        public Builder setStatus(ModelStatus status) {
            this.status = status;
            return this;
        }

        public Builder setCategoricalFeatures(Set<String> categoricalFeatures) {
            this.categoricalFeatures.clear();
            this.categoricalFeatures.addAll(categoricalFeatures);
            return this;
        }

        public Builder setEvaluationMetrics(EvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public Builder setFeatures(List<String> features) {
            this.features.clear();
            this.features.addAll(features);
            return this;
        }

        @Override
        public ModelMeta build() {
            return new ModelMeta(this.id, this.name, this.description, this.algorithm, this.split, this.predictionsDataset, this.status, this.directives, this.hyperparameters, this.features, this.outcome, this.categoricalFeatures, this.createtime, this.trainingtime, this.trainedtime, this.deploytime, this.evaluationMetrics);
        }
    }
}

