/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.modeler.param;

import co.cask.mmds.modeler.param.GBTParams;
import co.cask.mmds.spec.ParamSpec;
import co.cask.mmds.spec.Params;
import co.cask.mmds.spec.StringParam;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.ml.regression.GBTRegressor;
import org.apache.spark.ml.tree.DecisionTreeParams;

public class GBTRegressionParams
extends GBTParams {
    private final StringParam lossType;

    public GBTRegressionParams(Map<String, String> modelParams) {
        super(modelParams);
        this.lossType = new StringParam("lossType", "Loss Type", "Loss function which GBT tries to minimize. Supports 'squared' (L2) and 'absolute' (L1)", "squared", (Set<String>)ImmutableSet.of((Object)"squared", (Object)"absolute"), modelParams);
    }

    public void setParams(GBTRegressor gbt) {
        super.setParams((DecisionTreeParams)gbt);
        gbt.setMaxIter(((Integer)this.maxIterations.getVal()).intValue());
        gbt.setSubsamplingRate(((Double)this.subsamplingRate.getVal()).doubleValue());
        gbt.setStepSize(((Double)this.stepSize.getVal()).doubleValue());
        gbt.setLossType((String)this.lossType.getVal());
    }

    @Override
    public Map<String, String> toMap() {
        return Params.putParams(super.toMap(), this.lossType);
    }

    @Override
    public List<ParamSpec> getSpec() {
        return Params.addParams(super.getSpec(), this.lossType);
    }
}

