/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.modeler;

import co.cask.mmds.api.Modeler;
import co.cask.mmds.modeler.DecisionTreeClassifierModeler;
import co.cask.mmds.modeler.DecisionTreeRegressionModeler;
import co.cask.mmds.modeler.GBTClassifierModeler;
import co.cask.mmds.modeler.GBTRegressionModeler;
import co.cask.mmds.modeler.GeneralizedLinearRegressionModeler;
import co.cask.mmds.modeler.LinearRegressionModeler;
import co.cask.mmds.modeler.LogisticRegressionModeler;
import co.cask.mmds.modeler.MultilayerPerceptronModeler;
import co.cask.mmds.modeler.NaiveBayesModeler;
import co.cask.mmds.modeler.RandomForestClassifierModeler;
import co.cask.mmds.modeler.RandomForestRegressionModeler;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Modelers {
    private static final List<Modeler> MODELERS = ImmutableList.of((Object)new DecisionTreeRegressionModeler(), (Object)new GeneralizedLinearRegressionModeler(), (Object)new GBTRegressionModeler(), (Object)new LinearRegressionModeler(), (Object)new RandomForestRegressionModeler(), (Object)new DecisionTreeClassifierModeler(), (Object)new GBTClassifierModeler(), (Object)new LogisticRegressionModeler(), (Object)new MultilayerPerceptronModeler(), (Object)new NaiveBayesModeler(), (Object)new RandomForestClassifierModeler());
    private static final Map<String, Modeler> MODELER_MAP = MODELERS.stream().collect(Collectors.toMap(modeler -> modeler.getAlgorithm().getId(), modeler -> modeler));

    public static Collection<String> getAlgorithms() {
        return MODELER_MAP.keySet();
    }

    public static Collection<Modeler> getModelers() {
        return MODELERS;
    }

    @Nullable
    public static Modeler getModeler(String algorithm) {
        return MODELER_MAP.get(algorithm);
    }
}

