/*
 * Decompiled with CFR 0.152.
 */
package co.cask.mmds.data;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.dataset.DatasetProperties;
import co.cask.cdap.api.dataset.lib.PartitionDetail;
import co.cask.cdap.api.dataset.lib.PartitionFilter;
import co.cask.cdap.api.dataset.lib.PartitionKey;
import co.cask.cdap.api.dataset.lib.PartitionMetadata;
import co.cask.cdap.api.dataset.lib.PartitionOutput;
import co.cask.cdap.api.dataset.lib.PartitionedFileSet;
import co.cask.cdap.api.dataset.lib.PartitionedFileSetProperties;
import co.cask.cdap.api.dataset.lib.Partitioning;
import co.cask.mmds.data.ColumnSplitStats;
import co.cask.mmds.data.DataSplit;
import co.cask.mmds.data.DataSplitStats;
import co.cask.mmds.data.SplitKey;
import co.cask.mmds.data.SplitStatus;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.twill.filesystem.Location;

public class DataSplitTable {
    private static final Type SET_TYPE = new TypeToken<Set<String>>(){}.getType();
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Type LIST_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final Type STATS_TYPE = new TypeToken<List<ColumnSplitStats>>(){}.getType();
    private static final Gson GSON = new Gson();
    private static final String EXPERIMENT = "exp";
    private static final String SPLIT = "split";
    private static final String MODELS = "models";
    private static final String DESCRIPTION = "desc";
    private static final String TYPE = "type";
    private static final String PARAMS = "params";
    private static final String DIRECTIVES = "directives";
    private static final String SCHEMA = "schema";
    private static final String TEST_PATH = "test.path";
    private static final String TRAIN_PATH = "train.path";
    private static final String STATS = "stats";
    private static final String STATUS = "status";
    public static final DatasetProperties DATASET_PROPERTIES = PartitionedFileSetProperties.builder().setPartitioning(Partitioning.builder().addStringField("exp").addStringField("split").build()).setEnableExploreOnCreate(false).setDescription("Contains data splits used to train models").build();
    private final PartitionedFileSet splits;

    public DataSplitTable(PartitionedFileSet splits) {
        this.splits = splits;
    }

    public String addSplit(String experiment, DataSplit dataSplit) {
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        PartitionKey key = PartitionKey.builder().addStringField(EXPERIMENT, experiment).addStringField(SPLIT, id).build();
        PartitionOutput partitionOutput = this.splits.getPartitionOutput(key);
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put(DESCRIPTION, dataSplit.getDescription());
        meta.put(TYPE, dataSplit.getType());
        meta.put(PARAMS, GSON.toJson(dataSplit.getParams()));
        meta.put(DIRECTIVES, GSON.toJson(dataSplit.getDirectives()));
        meta.put(SCHEMA, dataSplit.getSchema().toString());
        meta.put(STATUS, SplitStatus.SPLITTING.name());
        partitionOutput.setMetadata(meta);
        partitionOutput.addPartition();
        return id;
    }

    public List<DataSplitStats> list(String experiment) {
        ArrayList<DataSplitStats> output = new ArrayList<DataSplitStats>();
        PartitionFilter filter = PartitionFilter.builder().addValueCondition(EXPERIMENT, (Comparable)((Object)experiment)).build();
        for (PartitionDetail partitionDetail : this.splits.getPartitions(filter)) {
            output.add(this.toSplitStats(partitionDetail, true));
        }
        return output;
    }

    @Nullable
    public DataSplitStats get(SplitKey key) {
        PartitionDetail partitionDetail = this.splits.getPartition(this.getKey(key));
        if (partitionDetail == null) {
            return null;
        }
        return this.toSplitStats(partitionDetail, false);
    }

    @Nullable
    public Location getLocation(SplitKey key) {
        PartitionDetail partitionDetail = this.splits.getPartition(this.getKey(key));
        if (partitionDetail == null) {
            return null;
        }
        return partitionDetail.getLocation();
    }

    public void setStatus(SplitKey splitKey, SplitStatus status) {
        PartitionKey key = this.getKey(splitKey);
        HashMap<String, String> updates = new HashMap<String, String>();
        updates.put(STATUS, status.name());
        this.splits.setMetadata(key, updates);
    }

    public void delete(SplitKey splitKey) {
        this.splits.dropPartition(this.getKey(splitKey));
    }

    public void delete(String experiment) {
        PartitionFilter filter = PartitionFilter.builder().addValueCondition(EXPERIMENT, (Comparable)((Object)experiment)).build();
        for (PartitionDetail partitionDetail : this.splits.getPartitions(filter)) {
            this.splits.dropPartition(partitionDetail.getPartitionKey());
        }
    }

    public void updateStats(SplitKey splitKey, String trainingPath, String testPath, List<ColumnSplitStats> stats) {
        PartitionKey key = this.getKey(splitKey);
        HashMap<String, String> updates = new HashMap<String, String>();
        updates.put(TRAIN_PATH, trainingPath);
        updates.put(TEST_PATH, testPath);
        updates.put(STATS, GSON.toJson(stats));
        updates.put(STATUS, SplitStatus.COMPLETE.name());
        this.splits.setMetadata(key, updates);
    }

    public void unregisterModel(SplitKey splitKey, String model) {
        PartitionKey key = this.getKey(splitKey);
        PartitionDetail partitionDetail = this.splits.getPartition(key);
        if (partitionDetail == null) {
            return;
        }
        HashMap<String, String> updates = new HashMap<String, String>();
        String modelsStr = partitionDetail.getMetadata().get(MODELS);
        Set models = new HashSet();
        if (modelsStr != null) {
            models = (Set)GSON.fromJson(modelsStr, SET_TYPE);
        }
        models.remove(model);
        updates.put(MODELS, GSON.toJson(models));
        this.splits.setMetadata(key, updates);
    }

    public void registerModel(SplitKey splitKey, String model) {
        PartitionKey key = this.getKey(splitKey);
        PartitionDetail partitionDetail = this.splits.getPartition(key);
        HashMap<String, String> updates = new HashMap<String, String>();
        String modelsStr = partitionDetail.getMetadata().get(MODELS);
        Set<String> models = new HashSet<String>();
        if (modelsStr != null) {
            models = (Set)GSON.fromJson(modelsStr, SET_TYPE);
        }
        models.add(model);
        updates.put(MODELS, GSON.toJson(models));
        this.splits.setMetadata(key, updates);
    }

    private PartitionKey getKey(SplitKey key) {
        return PartitionKey.builder().addStringField(EXPERIMENT, key.getExperiment()).addStringField(SPLIT, key.getSplit()).build();
    }

    private DataSplitStats toSplitStats(PartitionDetail partitionDetail, boolean excludeStats) {
        Schema schema;
        String id = (String)((Object)partitionDetail.getPartitionKey().getField(SPLIT));
        PartitionMetadata meta = partitionDetail.getMetadata();
        Map params = (Map)GSON.fromJson(meta.get(PARAMS), MAP_TYPE);
        List directives = (List)GSON.fromJson(meta.get(DIRECTIVES), LIST_TYPE);
        try {
            schema = Schema.parseJson((String)meta.get(SCHEMA));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to parse split schema. This is likely due to data corruption. You will likely have to delete the split.");
        }
        HashSet<String> models = new HashSet();
        String modelsStr = meta.get(MODELS);
        if (modelsStr != null) {
            models = (Set)GSON.fromJson(modelsStr, SET_TYPE);
        }
        DataSplitStats.Builder builder = ((DataSplitStats.Builder)((DataSplitStats.Builder)((DataSplitStats.Builder)((DataSplitStats.Builder)((DataSplitStats.Builder)DataSplitStats.builder(id).setDescription(meta.get(DESCRIPTION))).setType(meta.get(TYPE))).setParams(params)).setDirectives(directives)).setSchema(schema)).setTrainingPath(meta.get(TRAIN_PATH)).setTestPath(meta.get(TEST_PATH)).setModels(models).setStatus(SplitStatus.valueOf(meta.get(STATUS)));
        if (!excludeStats) {
            String statsStr = meta.get(STATS);
            List<ColumnSplitStats> stats = new ArrayList<ColumnSplitStats>();
            if (statsStr != null) {
                stats = (List)GSON.fromJson(statsStr, STATS_TYPE);
            }
            builder.setStats(stats);
        }
        return builder.build();
    }
}

