/*
 * Copyright © 2017 Cask Data, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package co.cask.microservice.api;

import java.util.Collections;
import java.util.Map;

/**
 * Represents a data conduit in or out of the Microservice.
 */
public class Channel {
  private final ChannelType type;
  private final String name;
  private final Map<String, String> properties;

  public Channel(ChannelType type, String name, Map<String, String> properties) {
    this.type = type;
    this.name = name;
    this.properties = Collections.unmodifiableMap(properties);
  }

  public ChannelType getType() {
    return type;
  }

  public String getName() {
    return name;
  }

  public Map<String, String> getProperties() {
    return properties;
  }

  @Override
  public String toString() {
    return "Channel{" +
      "type='" + type + '\'' +
      "name='" + name + '\'' +
      ", properties=" + properties +
      '}';
  }
}
