/*
 * Decompiled with CFR 0.152.
 */
package co.cask.microservice.api;

import co.cask.cdap.api.Admin;
import co.cask.cdap.api.TxRunnable;
import co.cask.cdap.api.data.DatasetInstantiationException;
import co.cask.cdap.api.data.stream.StreamBatchWriter;
import co.cask.cdap.api.dataset.Dataset;
import co.cask.cdap.api.metrics.Metrics;
import co.cask.cdap.api.stream.StreamEventData;
import co.cask.cdap.api.worker.WorkerContext;
import co.cask.microservice.annotation.PublicEvolving;
import co.cask.microservice.api.MicroserviceConfiguration;
import co.cask.microservice.api.MicroserviceDefinition;
import co.cask.microservice.api.Plugin;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.tephra.TransactionFailureException;

@PublicEvolving
public final class MicroserviceContext {
    private final WorkerContext delegate;
    private final MicroserviceDefinition definition;
    private final Metrics metrics;

    public MicroserviceContext(WorkerContext delegate, Metrics metrics, MicroserviceDefinition definition) {
        this.delegate = delegate;
        this.metrics = metrics;
        this.definition = definition;
    }

    public void write(String stream, String data) throws IOException {
        this.delegate.write(stream, data);
    }

    void write(String stream, String data, Map<String, String> headers) throws IOException {
        this.delegate.write(stream, data, headers);
    }

    void write(String stream, ByteBuffer data) throws IOException {
        this.delegate.write(stream, data);
    }

    void write(String stream, StreamEventData data) throws IOException {
        this.delegate.write(stream, data);
    }

    void writeFile(String stream, File file, String contentType) throws IOException {
        this.delegate.writeFile(stream, file, contentType);
    }

    public StreamBatchWriter createBatchWriter(String stream, String contentType) throws IOException {
        return this.delegate.createBatchWriter(stream, contentType);
    }

    public String getId() {
        return this.definition.getId();
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public String getDescription() {
        return this.definition.getDescription();
    }

    public Plugin getPlugin() {
        return this.definition.getPlugin();
    }

    public MicroserviceConfiguration getConfiguration() {
        return this.definition.getConfiguration();
    }

    public String getNamespace() {
        return this.delegate.getNamespace();
    }

    public String getClusterName() {
        return this.delegate.getClusterName();
    }

    public int getInstanceCount() {
        return this.delegate.getInstanceCount();
    }

    public int getInstanceId() {
        return this.delegate.getInstanceId();
    }

    public Admin getAdmin() {
        return this.delegate.getAdmin();
    }

    public void execute(TxRunnable runnable) throws TransactionFailureException {
        this.delegate.execute(runnable);
    }

    public void execute(int timeoutInSeconds, TxRunnable runnable) throws TransactionFailureException {
        this.delegate.execute(timeoutInSeconds, runnable);
    }

    public <T extends Dataset> T getDataset(String name) throws DatasetInstantiationException {
        return (T)this.delegate.getDataset(name);
    }

    public <T extends Dataset> T getDataset(String namespace, String name) throws DatasetInstantiationException {
        return (T)this.delegate.getDataset(namespace, name);
    }

    public <T extends Dataset> T getDataset(String name, Map<String, String> arguments) throws DatasetInstantiationException {
        return (T)this.delegate.getDataset(name, arguments);
    }

    public <T extends Dataset> T getDataset(String namespace, String name, Map<String, String> arguments) throws DatasetInstantiationException {
        return (T)this.delegate.getDataset(namespace, name, arguments);
    }

    public void releaseDataset(Dataset dataset) {
        this.delegate.releaseDataset(dataset);
    }

    public void discardDataset(Dataset dataset) {
        this.delegate.discardDataset(dataset);
    }
}

