/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.plugin;

import co.cask.cdap.api.annotation.Description;
import co.cask.cdap.api.annotation.Macro;
import co.cask.cdap.api.annotation.Name;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.plugin.PluginConfig;
import co.cask.hydrator.common.IdUtils;
import co.cask.hydrator.format.FileFormat;
import co.cask.hydrator.format.plugin.FileSourceProperties;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class AbstractFileSourceConfig
extends PluginConfig
implements FileSourceProperties {
    @Description(value="Name be used to uniquely identify this source for lineage, annotating metadata, etc.")
    private String referenceName;
    @Macro
    @Nullable
    @Description(value="Regular expression that file paths must match in order to be included in the input. The full file path is compared, not just the file name.If no value is given, no file filtering will be done. See https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for more information about the regular expression syntax.")
    private String fileRegex;
    @Macro
    @Nullable
    @Description(value="Format of the data to read. Supported formats are 'avro', 'blob', 'csv', 'delimited', 'json', 'parquet', 'text', or 'tsv'. ")
    private String format = FileFormat.TEXT.name().toLowerCase();
    @Nullable
    @Description(value="Maximum size of each partition used to read data. Smaller partitions will increase the level of parallelism, but will require more resources and overhead.")
    @Macro
    private Long maxSplitSize = 0x8000000L;
    @Nullable
    @Description(value="Whether to allow an input that does not exist. When false, the source will fail the run if the input does not exist. When true, the run will not fail and the source will not generate any output. The default value is false.")
    private Boolean ignoreNonExistingFolders = false;
    @Nullable
    @Description(value="Whether to recursively read directories within the input directory. The default is false.")
    private Boolean recursive = false;
    @Name(value="pathField")
    @Nullable
    @Description(value="Output field to place the path of the file that the record was read from. If not specified, the file path will not be included in output records. If specified, the field must exist in the output schema as a string.")
    private String pathField;
    @Nullable
    @Description(value="Whether to only use the filename instead of the URI of the file path when a path field is given. The default value is false.")
    private Boolean filenameOnly = false;
    @Nullable
    @Description(value="Output schema for the source. Formats like 'avro' and 'parquet' require a schema in order to read the data.")
    private String schema;
    @Macro
    @Nullable
    @Description(value="The delimiter to use if the format is 'delimited'. The delimiter will be ignored if the format is anything other than 'delimited'.")
    private String delimiter;
    @Nullable
    private Boolean copyHeader = false;

    protected AbstractFileSourceConfig() {
    }

    @Override
    public void validate() {
        IdUtils.validateId((String)this.referenceName);
        Object fileFormat = null;
        if (!this.containsMacro("format")) {
            this.getFormat();
        }
        Object schema = null;
        if (!this.containsMacro("schema")) {
            this.getSchema();
        }
    }

    @Override
    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public FileFormat getFormat() {
        return this.containsMacro("format") ? null : FileFormat.from(this.format, FileFormat::canRead);
    }

    @Override
    @Nullable
    public Pattern getFilePattern() {
        return this.fileRegex == null ? null : Pattern.compile(this.fileRegex);
    }

    @Override
    public long getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Override
    public boolean shouldAllowEmptyInput() {
        return this.ignoreNonExistingFolders;
    }

    @Override
    public boolean shouldReadRecursively() {
        return this.recursive;
    }

    @Override
    @Nullable
    public String getPathField() {
        return this.pathField;
    }

    @Override
    public boolean useFilenameAsPath() {
        return this.filenameOnly;
    }

    @Override
    @Nullable
    public Schema getSchema() {
        try {
            return this.containsMacro("schema") || this.schema == null ? null : Schema.parseJson((String)this.schema);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse schema with error: " + e.getMessage(), e);
        }
    }

    public boolean shouldCopyHeader() {
        return this.copyHeader;
    }
}

