/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.plugin;

import co.cask.cdap.api.annotation.Description;
import co.cask.cdap.api.annotation.Macro;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.plugin.PluginConfig;
import co.cask.hydrator.common.IdUtils;
import co.cask.hydrator.format.FileFormat;
import co.cask.hydrator.format.plugin.FileSinkProperties;
import java.io.IOException;
import java.text.SimpleDateFormat;
import javax.annotation.Nullable;

public abstract class AbstractFileSinkConfig
extends PluginConfig
implements FileSinkProperties {
    @Description(value="Name be used to uniquely identify this sink for lineage, annotating metadata, etc.")
    private String referenceName;
    @Macro
    @Nullable
    @Description(value="The time format for the output directory that will be appended to the path. For example, the format 'yyyy-MM-dd-HH-mm' will result in a directory of the form '2015-01-01-20-42'. If not specified, nothing will be appended to the path.")
    private String suffix;
    @Macro
    @Description(value="The format to write in. The format must be one of 'json', 'avro', 'parquet', 'csv', 'tsv', or 'delimited'.")
    private String format;
    @Macro
    @Nullable
    @Description(value="The delimiter to use if the format is 'delimited'. The delimiter will be ignored if the format is anything other than 'delimited'.")
    private String delimiter;
    @Macro
    @Nullable
    @Description(value="The schema of the data to write.")
    private String schema;

    @Override
    public void validate() {
        IdUtils.validateId((String)this.referenceName);
        if (this.suffix != null && !this.containsMacro("suffix")) {
            new SimpleDateFormat(this.suffix);
        }
        if (!this.containsMacro("format")) {
            this.getFormat();
        }
        this.getSchema();
    }

    @Override
    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    @Nullable
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    @Nullable
    public Schema getSchema() {
        if (this.containsMacro("schema") || this.schema == null) {
            return null;
        }
        try {
            return Schema.parseJson((String)this.schema);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse schema: " + e.getMessage(), e);
        }
    }

    @Override
    public FileFormat getFormat() {
        return FileFormat.from(this.format, FileFormat::canWrite);
    }
}

