/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.output;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.dataset.lib.KeyValue;
import co.cask.hydrator.format.StructuredToAvroTransformer;
import co.cask.hydrator.format.output.FileOutputFormatter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.parquet.avro.AvroParquetOutputFormat;

public class ParquetOutputFormatter
implements FileOutputFormatter<Void, GenericRecord> {
    private final StructuredToAvroTransformer recordTransformer;
    private final Schema schema;

    public ParquetOutputFormatter(Schema schema) {
        this.schema = schema;
        this.recordTransformer = new StructuredToAvroTransformer(schema);
    }

    @Override
    public KeyValue<Void, GenericRecord> transform(StructuredRecord record) throws IOException {
        return new KeyValue(null, (Object)this.recordTransformer.transform(record));
    }

    @Override
    public String getFormatClassName() {
        return AvroParquetOutputFormat.class.getName();
    }

    @Override
    public Map<String, String> getFormatConfig() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("parquet.avro.schema", this.schema.toString());
        return conf;
    }
}

