/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.output;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.dataset.lib.KeyValue;
import co.cask.cdap.format.StructuredRecordStringConverter;
import co.cask.hydrator.format.output.FileOutputFormatter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class JsonOutputFormatter
implements FileOutputFormatter<NullWritable, Text> {
    @Override
    public KeyValue<NullWritable, Text> transform(StructuredRecord record) {
        try {
            return new KeyValue((Object)NullWritable.get(), (Object)new Text(StructuredRecordStringConverter.toJsonString((StructuredRecord)record)));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to transform CDAP record into a JSON record.", e);
        }
    }

    @Override
    public String getFormatClassName() {
        return TextOutputFormat.class.getName();
    }

    @Override
    public Map<String, String> getFormatConfig() {
        return Collections.singletonMap("mapreduce.job.output.key.class", Text.class.getName());
    }
}

