/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.output;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.dataset.lib.KeyValue;
import co.cask.cdap.format.StructuredRecordStringConverter;
import co.cask.hydrator.format.output.FileOutputFormatter;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class DelimitedTextOutputFormatter
implements FileOutputFormatter<NullWritable, Text> {
    private final String delimiter;

    DelimitedTextOutputFormatter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public KeyValue<NullWritable, Text> transform(StructuredRecord record) {
        return new KeyValue((Object)NullWritable.get(), (Object)new Text(StructuredRecordStringConverter.toDelimitedString((StructuredRecord)record, (String)this.delimiter)));
    }

    @Override
    public String getFormatClassName() {
        return TextOutputFormat.class.getName();
    }

    @Override
    public Map<String, String> getFormatConfig() {
        return Collections.singletonMap("mapreduce.job.output.key.class", Text.class.getName());
    }
}

