/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.output;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.dataset.lib.KeyValue;
import co.cask.hydrator.format.StructuredToAvroTransformer;
import co.cask.hydrator.format.output.FileOutputFormatter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroKeyOutputFormat;
import org.apache.hadoop.io.NullWritable;

public class AvroOutputFormatter
implements FileOutputFormatter<AvroKey<GenericRecord>, NullWritable> {
    private final StructuredToAvroTransformer recordTransformer;
    private final Schema schema;

    AvroOutputFormatter(Schema schema) {
        this.recordTransformer = new StructuredToAvroTransformer(schema);
        this.schema = schema;
    }

    @Override
    public KeyValue<AvroKey<GenericRecord>, NullWritable> transform(StructuredRecord record) throws IOException {
        return new KeyValue((Object)new AvroKey((Object)this.recordTransformer.transform(record)), (Object)NullWritable.get());
    }

    @Override
    public String getFormatClassName() {
        return AvroKeyOutputFormat.class.getName();
    }

    @Override
    public Map<String, String> getFormatConfig() {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("avro.schema.output.key", this.schema.toString());
        conf.put("mapreduce.job.output.key.class", AvroKey.class.getName());
        return conf;
    }
}

