/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.input.FileInputFormatter;
import co.cask.hydrator.format.input.FileInputFormatterProvider;
import co.cask.hydrator.format.input.TextInputFormatter;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;

public class TextInputProvider
implements FileInputFormatterProvider {
    @Override
    @Nullable
    public Schema getSchema(@Nullable String pathField) {
        return TextInputProvider.getDefaultSchema(pathField);
    }

    @Override
    public FileInputFormatter create(Map<String, String> properties, @Nullable Schema schema) {
        Schema.Type bodyType;
        Schema.Field bodyField;
        String pathField = properties.get("pathField");
        if (schema == null) {
            return new TextInputFormatter(this.getSchema(pathField));
        }
        Schema.Field offsetField = schema.getField("offset");
        if (offsetField != null) {
            Schema.Type offsetType;
            Schema offsetSchema = offsetField.getSchema();
            Schema.Type type = offsetType = offsetSchema.isNullable() ? offsetSchema.getNonNullable().getType() : offsetSchema.getType();
            if (offsetType != Schema.Type.LONG) {
                throw new IllegalArgumentException(String.format("The 'offset' field must be of type 'long', but found '%s'", offsetType.name().toLowerCase()));
            }
        }
        if ((bodyField = schema.getField("body")) == null) {
            throw new IllegalArgumentException("The schema for the 'text' format must have a field named 'body'");
        }
        Schema bodySchema = bodyField.getSchema();
        Schema.Type type = bodyType = bodySchema.isNullable() ? bodySchema.getNonNullable().getType() : bodySchema.getType();
        if (bodyType != Schema.Type.STRING) {
            throw new IllegalArgumentException(String.format("The 'body' field must be of type 'string', but found '%s'", bodyType.name().toLowerCase()));
        }
        boolean expectOffset = schema.getField("offset") != null;
        boolean expectPath = pathField != null;
        int numExpectedFields = 1;
        if (expectOffset) {
            ++numExpectedFields;
        }
        if (expectPath) {
            ++numExpectedFields;
        }
        int maxExpectedFields = pathField == null ? 2 : 3;
        int numFields = schema.getFields().size();
        if (numFields > numExpectedFields) {
            String expectedFields = expectOffset && expectPath ? String.format("'offset', 'body', and '%s' fields", pathField) : (expectOffset ? "'offset' and 'body' fields" : (expectPath ? String.format("'body' and '%s' fields", pathField) : "'body' field"));
            int numExtraFields = numFields - maxExpectedFields;
            throw new IllegalArgumentException(String.format("The schema for the 'text' format must only contain the %s, but found %d other field%s", expectedFields, numExtraFields, numExtraFields > 1 ? "s" : ""));
        }
        return new TextInputFormatter(schema);
    }

    public static Schema getDefaultSchema(@Nullable String pathField) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(Schema.Field.of((String)"offset", (Schema)Schema.of((Schema.Type)Schema.Type.LONG)));
        fields.add(Schema.Field.of((String)"body", (Schema)Schema.of((Schema.Type)Schema.Type.STRING)));
        if (pathField != null && !pathField.isEmpty()) {
            fields.add(Schema.Field.of((String)pathField, (Schema)Schema.of((Schema.Type)Schema.Type.STRING)));
        }
        return Schema.recordOf((String)"textfile", fields);
    }
}

