/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.FileFormat;
import co.cask.hydrator.format.input.FileInputFormatter;
import co.cask.hydrator.format.input.TextInputProvider;
import co.cask.hydrator.format.plugin.FileSourceProperties;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class PathTrackingInputFormat
extends FileInputFormat<NullWritable, StructuredRecord> {
    public static final String COPY_HEADER = "path.tracking.copy.header";
    static final String PATH_FIELD = "path.tracking.path.field";
    private static final String FILENAME_ONLY = "path.tracking.filename.only";
    private static final String FORMAT = "path.tracking.format";
    private static final String SCHEMA = "path.tracking.schema";

    public static void configure(Job job, FileSourceProperties properties, Map<String, String> pluginProperties) {
        Configuration conf = job.getConfiguration();
        String pathField = properties.getPathField();
        if (pathField != null) {
            conf.set(PATH_FIELD, pathField);
        }
        conf.setBoolean(FILENAME_ONLY, properties.useFilenameAsPath());
        FileFormat format = properties.getFormat();
        if (format == null) {
            throw new IllegalArgumentException("A format must be specified.");
        }
        conf.set(FORMAT, format.name());
        Schema schema = properties.getSchema();
        if (schema != null) {
            conf.set(SCHEMA, schema.toString());
        }
        FileInputFormatter inputFormatter = format.getFileInputFormatter(pluginProperties, schema);
        for (Map.Entry<String, String> entry : inputFormatter.getFormatConfig().entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        FileFormat fileFormat = FileFormat.valueOf(context.getConfiguration().get(FORMAT));
        return fileFormat != FileFormat.BLOB;
    }

    @Deprecated
    public static Schema getTextOutputSchema(@Nullable String pathField) {
        return TextInputProvider.getDefaultSchema(pathField);
    }

    public RecordReader<NullWritable, StructuredRecord> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (!(split instanceof FileSplit)) {
            throw new IllegalStateException("Input split is not a FileSplit.");
        }
        FileSplit fileSplit = (FileSplit)split;
        Configuration hConf = context.getConfiguration();
        String pathField = hConf.get(PATH_FIELD);
        boolean filenameOnly = hConf.getBoolean(FILENAME_ONLY, false);
        FileFormat format = FileFormat.valueOf(hConf.get(FORMAT));
        String path = filenameOnly ? fileSplit.getPath().getName() : fileSplit.getPath().toUri().toString();
        String schema = hConf.get(SCHEMA);
        Schema parsedSchema = schema == null ? null : Schema.parseJson((String)schema);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (pathField != null) {
            properties.put("pathField", pathField);
        }
        FileInputFormatter inputFormatter = format.getFileInputFormatter(properties, parsedSchema);
        RecordReader<NullWritable, StructuredRecord.Builder> reader = inputFormatter.create(fileSplit, context);
        return new TrackingRecordReader(reader, pathField, path);
    }

    static class TrackingRecordReader
    extends RecordReader<NullWritable, StructuredRecord> {
        private final RecordReader<NullWritable, StructuredRecord.Builder> delegate;
        private final String pathField;
        private final String path;

        TrackingRecordReader(RecordReader<NullWritable, StructuredRecord.Builder> delegate, @Nullable String pathField, String path) {
            this.delegate = delegate;
            this.pathField = pathField;
            this.path = path;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.delegate.initialize(split, context);
        }

        public NullWritable getCurrentKey() {
            return NullWritable.get();
        }

        public StructuredRecord getCurrentValue() throws IOException, InterruptedException {
            StructuredRecord.Builder recordBuilder = (StructuredRecord.Builder)this.delegate.getCurrentValue();
            if (this.pathField != null) {
                recordBuilder.set(this.pathField, (Object)this.path);
            }
            return recordBuilder.build();
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.delegate.getProgress();
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.delegate.nextKeyValue();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

