/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.AvroToStructuredTransformer;
import co.cask.hydrator.format.input.FileInputFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.parquet.avro.AvroParquetInputFormat;

public class ParquetInputFormatter
implements FileInputFormatter {
    private final Schema schema;

    ParquetInputFormatter(@Nullable Schema schema) {
        this.schema = schema;
    }

    @Override
    public Map<String, String> getFormatConfig() {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.schema != null) {
            properties.put("parquet.avro.schema", this.schema.toString());
        }
        return properties;
    }

    @Override
    public RecordReader<NullWritable, StructuredRecord.Builder> create(FileSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration hConf = context.getConfiguration();
        String pathField = hConf.get("path.tracking.path.field");
        RecordReader delegate = new AvroParquetInputFormat().createRecordReader((InputSplit)split, context);
        return new ParquetRecordReader((RecordReader<Void, GenericRecord>)delegate, this.schema, pathField);
    }

    static class ParquetRecordReader
    extends RecordReader<NullWritable, StructuredRecord.Builder> {
        private final RecordReader<Void, GenericRecord> delegate;
        private final AvroToStructuredTransformer recordTransformer;
        private final String pathField;
        private Schema schema;

        ParquetRecordReader(RecordReader<Void, GenericRecord> delegate, @Nullable Schema schema, @Nullable String pathField) {
            this.delegate = delegate;
            this.schema = schema;
            this.pathField = pathField;
            this.recordTransformer = new AvroToStructuredTransformer();
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.delegate.initialize(split, context);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.delegate.nextKeyValue();
        }

        public NullWritable getCurrentKey() {
            return NullWritable.get();
        }

        public StructuredRecord.Builder getCurrentValue() throws IOException, InterruptedException {
            GenericRecord genericRecord = (GenericRecord)this.delegate.getCurrentValue();
            if (this.schema == null) {
                if (this.pathField == null) {
                    this.schema = Schema.parseJson((String)genericRecord.getSchema().toString());
                } else {
                    Schema schemaWithoutPath = Schema.parseJson((String)genericRecord.getSchema().toString());
                    ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>(schemaWithoutPath.getFields().size() + 1);
                    fields.addAll(schemaWithoutPath.getFields());
                    fields.add(Schema.Field.of((String)this.pathField, (Schema)Schema.of((Schema.Type)Schema.Type.STRING)));
                    this.schema = Schema.recordOf((String)schemaWithoutPath.getRecordName(), fields);
                }
            }
            return this.recordTransformer.transform(genericRecord, this.schema, this.pathField);
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.delegate.getProgress();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }
}

