/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.format.StructuredRecordStringConverter;
import co.cask.hydrator.format.input.FileInputFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class JsonInputFormatter
implements FileInputFormatter {
    private final Schema schema;

    JsonInputFormatter(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Map<String, String> getFormatConfig() {
        return Collections.emptyMap();
    }

    private Schema getModifiedSchema(@Nullable String pathField) {
        if (pathField == null) {
            return this.schema;
        }
        ArrayList<Schema.Field> fieldCopies = new ArrayList<Schema.Field>(this.schema.getFields().size());
        for (Schema.Field field : this.schema.getFields()) {
            if (field.getName().equals(pathField) && !field.getSchema().isNullable()) {
                fieldCopies.add(Schema.Field.of((String)field.getName(), (Schema)Schema.nullableOf((Schema)field.getSchema())));
                continue;
            }
            fieldCopies.add(field);
        }
        return Schema.recordOf((String)this.schema.getRecordName(), fieldCopies);
    }

    @Override
    public RecordReader<NullWritable, StructuredRecord.Builder> create(FileSplit split, TaskAttemptContext context) {
        final RecordReader delegate = new TextInputFormat().createRecordReader((InputSplit)split, context);
        Configuration hConf = context.getConfiguration();
        String pathField = hConf.get("path.tracking.path.field");
        final Schema modifiedSchema = this.getModifiedSchema(pathField);
        return new RecordReader<NullWritable, StructuredRecord.Builder>(){

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                delegate.initialize(split, context);
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return delegate.nextKeyValue();
            }

            public NullWritable getCurrentKey() {
                return NullWritable.get();
            }

            public StructuredRecord.Builder getCurrentValue() throws IOException, InterruptedException {
                String json = ((Text)delegate.getCurrentValue()).toString();
                StructuredRecord record = StructuredRecordStringConverter.fromJsonString((String)json, (Schema)modifiedSchema);
                StructuredRecord.Builder builder = StructuredRecord.builder((Schema)JsonInputFormatter.this.schema);
                for (Schema.Field field : JsonInputFormatter.this.schema.getFields()) {
                    builder.set(field.getName(), record.get(field.getName()));
                }
                return builder;
            }

            public float getProgress() throws IOException, InterruptedException {
                return delegate.getProgress();
            }

            public void close() throws IOException {
                delegate.close();
            }
        };
    }
}

