/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.input.FileInputFormatter;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class DelimitedTextInputFormatter
implements FileInputFormatter {
    private final Schema schema;
    private final String delimiter;

    DelimitedTextInputFormatter(Schema schema, String delimiter) {
        this.schema = schema;
        this.delimiter = delimiter;
    }

    @Override
    public Map<String, String> getFormatConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("delimiter", this.delimiter);
        return config;
    }

    @Override
    public RecordReader<NullWritable, StructuredRecord.Builder> create(FileSplit split, TaskAttemptContext context) {
        final RecordReader delegate = new TextInputFormat().createRecordReader((InputSplit)split, context);
        final String delimiter = context.getConfiguration().get("delimiter");
        return new RecordReader<NullWritable, StructuredRecord.Builder>(){

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                delegate.initialize(split, context);
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return delegate.nextKeyValue();
            }

            public NullWritable getCurrentKey() {
                return NullWritable.get();
            }

            public StructuredRecord.Builder getCurrentValue() throws IOException, InterruptedException {
                String delimitedString = ((Text)delegate.getCurrentValue()).toString();
                StructuredRecord.Builder builder = StructuredRecord.builder((Schema)DelimitedTextInputFormatter.this.schema);
                Iterator fields = DelimitedTextInputFormatter.this.schema.getFields().iterator();
                for (String part : Splitter.on((String)delimiter).split((CharSequence)delimitedString)) {
                    if (part.isEmpty()) {
                        builder.set(((Schema.Field)fields.next()).getName(), null);
                        continue;
                    }
                    builder.convertAndSet(((Schema.Field)fields.next()).getName(), part);
                }
                return builder;
            }

            public float getProgress() throws IOException, InterruptedException {
                return delegate.getProgress();
            }

            public void close() throws IOException {
                delegate.close();
            }
        };
    }
}

