/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.input.DelimitedTextInputFormatter;
import co.cask.hydrator.format.input.FileInputFormatter;
import co.cask.hydrator.format.input.FileInputFormatterProvider;
import java.util.Map;
import javax.annotation.Nullable;

public class DelimitedInputProvider
implements FileInputFormatterProvider {
    private final String constantDelimiter;

    public DelimitedInputProvider(@Nullable String constantDelimiter) {
        this.constantDelimiter = constantDelimiter;
    }

    @Override
    @Nullable
    public Schema getSchema(@Nullable String pathField) {
        return null;
    }

    @Override
    public FileInputFormatter create(Map<String, String> properties, @Nullable Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("Delimited format cannot be used without specifying a schema.");
        }
        String delimiter = this.constantDelimiter == null ? properties.getOrDefault("delimiter", ",") : this.constantDelimiter;
        return new DelimitedTextInputFormatter(schema, delimiter);
    }
}

