/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.hydrator.format.input.CombineHeaderFileSplit;
import co.cask.hydrator.format.input.PathTrackingInputFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReader;
import org.apache.hadoop.mapreduce.lib.input.CombineFileRecordReaderWrapper;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class CombinePathTrackingInputFormat
extends CombineFileInputFormat<NullWritable, StructuredRecord> {
    static final String HEADER = "combine.path.tracking.header";

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List fileSplits = super.getSplits(job);
        Configuration hConf = job.getConfiguration();
        boolean shouldCopyHeader = hConf.getBoolean("path.tracking.copy.header", false);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(fileSplits.size());
        String header = null;
        for (InputSplit split : fileSplits) {
            CombineFileSplit combineFileSplit = (CombineFileSplit)split;
            if (shouldCopyHeader && header == null) {
                header = this.getHeader(hConf, combineFileSplit);
            }
            splits.add((InputSplit)new CombineHeaderFileSplit(combineFileSplit, header));
        }
        return splits;
    }

    @Nullable
    private String getHeader(Configuration hConf, CombineFileSplit split) throws IOException {
        String header = null;
        for (Path path : split.getPaths()) {
            try (FileSystem fs = path.getFileSystem(hConf);
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(path), StandardCharsets.UTF_8));){
                header = reader.readLine();
                if (header == null) continue;
                break;
            }
        }
        return header;
    }

    public RecordReader<NullWritable, StructuredRecord> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        CombineHeaderFileSplit combineSplit = (CombineHeaderFileSplit)split;
        if (combineSplit.getHeader() != null) {
            context.getConfiguration().set(HEADER, combineSplit.getHeader());
        }
        return new CombineFileRecordReader((CombineFileSplit)combineSplit, context, RecordReaderWrapper.class);
    }

    private static class RecordReaderWrapper
    extends CombineFileRecordReaderWrapper<NullWritable, StructuredRecord> {
        RecordReaderWrapper(CombineFileSplit split, TaskAttemptContext context, Integer idx) throws IOException, InterruptedException {
            super((FileInputFormat)new PathTrackingInputFormat(), split, context, idx);
        }
    }
}

