/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.input.BlobInputFormatter;
import co.cask.hydrator.format.input.FileInputFormatter;
import co.cask.hydrator.format.input.FileInputFormatterProvider;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;

public class BlobInputProvider
implements FileInputFormatterProvider {
    @Override
    @Nullable
    public Schema getSchema(@Nullable String pathField) {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(Schema.Field.of((String)"body", (Schema)Schema.of((Schema.Type)Schema.Type.BYTES)));
        if (pathField != null && !pathField.isEmpty()) {
            fields.add(Schema.Field.of((String)pathField, (Schema)Schema.of((Schema.Type)Schema.Type.STRING)));
        }
        return Schema.recordOf((String)"blob", fields);
    }

    @Override
    public FileInputFormatter create(Map<String, String> properties, @Nullable Schema schema) {
        Schema.Type bodyType;
        String pathField = properties.get("pathField");
        if (schema == null) {
            return new BlobInputFormatter(this.getSchema(pathField));
        }
        Schema.Field bodyField = schema.getField("body");
        if (bodyField == null) {
            throw new IllegalArgumentException("The schema for the 'blob' format must have a field named 'body'");
        }
        Schema bodySchema = bodyField.getSchema();
        Schema.Type type = bodyType = bodySchema.isNullable() ? bodySchema.getNonNullable().getType() : bodySchema.getType();
        if (bodyType != Schema.Type.BYTES) {
            throw new IllegalArgumentException(String.format("The 'body' field must be of type 'bytes', but found '%s'", bodyType.name().toLowerCase()));
        }
        int numExpectedFields = pathField == null ? 1 : 2;
        int numFields = schema.getFields().size();
        if (numFields > numExpectedFields) {
            int numExtra = numFields - numExpectedFields;
            if (pathField == null) {
                throw new IllegalArgumentException(String.format("The schema for the 'blob' format must only contain the 'body' field, but found %d other field%s.", numFields - 1, numExtra > 1 ? "s" : ""));
            }
            throw new IllegalArgumentException(String.format("The schema for the 'blob' format must only contain the 'body' field and the '%s' field, but found %d other field%s.", pathField, numFields - 2, numExtra > 1 ? "s" : ""));
        }
        return new BlobInputFormatter(schema);
    }
}

