/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format.input;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.input.FileInputFormatter;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class BlobInputFormatter
implements FileInputFormatter {
    private final Schema schema;

    BlobInputFormatter(Schema schema) {
        this.schema = schema;
    }

    @Override
    public Map<String, String> getFormatConfig() {
        return Collections.emptyMap();
    }

    @Override
    public RecordReader<NullWritable, StructuredRecord.Builder> create(final FileSplit split, final TaskAttemptContext context) {
        if (split.getLength() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Blob format cannot be used with files larger than 2GB");
        }
        return new RecordReader<NullWritable, StructuredRecord.Builder>(){
            boolean hasNext;
            byte[] val;

            public void initialize(InputSplit split2, TaskAttemptContext context2) {
                this.hasNext = true;
                this.val = null;
            }

            public boolean nextKeyValue() throws IOException {
                if (!this.hasNext) {
                    return false;
                }
                this.hasNext = false;
                if (split.getLength() == 0L) {
                    return false;
                }
                Path path = split.getPath();
                FileSystem fs = path.getFileSystem(context.getConfiguration());
                try (FSDataInputStream input = fs.open(path);){
                    this.val = new byte[(int)split.getLength()];
                    ByteStreams.readFully((InputStream)input, (byte[])this.val);
                }
                return true;
            }

            public NullWritable getCurrentKey() {
                return NullWritable.get();
            }

            public StructuredRecord.Builder getCurrentValue() {
                String fieldName = ((Schema.Field)BlobInputFormatter.this.schema.getFields().iterator().next()).getName();
                return StructuredRecord.builder((Schema)BlobInputFormatter.this.schema).set(fieldName, (Object)this.val);
            }

            public float getProgress() {
                return 0.0f;
            }

            public void close() {
            }
        };
    }
}

