/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.common.RecordConverter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;

public class StructuredToAvroTransformer
extends RecordConverter<StructuredRecord, GenericRecord> {
    private final Map<Integer, Schema> schemaCache = Maps.newHashMap();
    private final co.cask.cdap.api.data.schema.Schema outputCDAPSchema;

    public StructuredToAvroTransformer(@Nullable co.cask.cdap.api.data.schema.Schema outputSchema) {
        this.outputCDAPSchema = outputSchema;
    }

    public GenericRecord transform(StructuredRecord structuredRecord) throws IOException {
        return this.transform(structuredRecord, this.outputCDAPSchema == null ? structuredRecord.getSchema() : this.outputCDAPSchema);
    }

    public GenericRecord transform(StructuredRecord structuredRecord, co.cask.cdap.api.data.schema.Schema schema) throws IOException {
        co.cask.cdap.api.data.schema.Schema structuredRecordSchema = structuredRecord.getSchema();
        Schema avroSchema = this.getAvroSchema(schema);
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(avroSchema);
        for (Schema.Field field : avroSchema.getFields()) {
            String fieldName = field.name();
            Schema.Field schemaField = structuredRecordSchema.getField(fieldName);
            if (schemaField == null) {
                throw new IllegalArgumentException("Input record does not contain the " + fieldName + " field.");
            }
            recordBuilder.set(fieldName, this.convertField(structuredRecord.get(fieldName), schemaField.getSchema()));
        }
        return recordBuilder.build();
    }

    protected Object convertBytes(Object field) {
        if (field instanceof ByteBuffer) {
            return field;
        }
        return ByteBuffer.wrap((byte[])field);
    }

    private Schema getAvroSchema(co.cask.cdap.api.data.schema.Schema cdapSchema) {
        int hashCode = cdapSchema.hashCode();
        if (this.schemaCache.containsKey(hashCode)) {
            return this.schemaCache.get(hashCode);
        }
        Schema avroSchema = new Schema.Parser().parse(cdapSchema.toString());
        this.schemaCache.put(hashCode, avroSchema);
        return avroSchema;
    }
}

