/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class RegexPathFilter
extends Configured
implements PathFilter {
    private static final String REGEX = "path.filter.regex";
    private Pattern pattern;

    public static void configure(Configuration conf, Pattern regex) {
        conf.set(REGEX, regex.pattern());
    }

    public boolean accept(Path path) {
        try {
            FileSystem fileSystem = path.getFileSystem(new Configuration());
            if (fileSystem.isDirectory(path)) {
                return true;
            }
            if (fileSystem.isFile(path)) {
                return this.pattern == null || this.pattern.matcher(path.toUri().getPath()).matches();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf == null) {
            return;
        }
        String regex = conf.get(REGEX);
        this.pattern = regex == null ? null : Pattern.compile(regex);
    }
}

