/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format;

import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.format.input.AvroInputProvider;
import co.cask.hydrator.format.input.BlobInputProvider;
import co.cask.hydrator.format.input.DelimitedInputProvider;
import co.cask.hydrator.format.input.FileInputFormatter;
import co.cask.hydrator.format.input.FileInputFormatterProvider;
import co.cask.hydrator.format.input.JsonInputProvider;
import co.cask.hydrator.format.input.ParquetInputProvider;
import co.cask.hydrator.format.input.TextInputProvider;
import co.cask.hydrator.format.output.AvroOutputProvider;
import co.cask.hydrator.format.output.DelimitedTextOutputProvider;
import co.cask.hydrator.format.output.FileOutputFormatter;
import co.cask.hydrator.format.output.FileOutputFormatterProvider;
import co.cask.hydrator.format.output.JsonOutputProvider;
import co.cask.hydrator.format.output.ParquetOutputProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public enum FileFormat {
    AVRO(new AvroInputProvider(), new AvroOutputProvider()),
    BLOB(new BlobInputProvider(), null),
    CSV(new DelimitedInputProvider(","), new DelimitedTextOutputProvider(",")),
    DELIMITED(new DelimitedInputProvider(null), new DelimitedTextOutputProvider(null)),
    JSON(new JsonInputProvider(), new JsonOutputProvider()),
    PARQUET(new ParquetInputProvider(), new ParquetOutputProvider()),
    TEXT(new TextInputProvider(), null),
    TSV(new DelimitedInputProvider("\t"), new DelimitedTextOutputProvider("\t"));

    private final FileInputFormatterProvider inputProvider;
    private final FileOutputFormatterProvider outputProvider;
    private final boolean canWrite;
    private final boolean canRead;

    private FileFormat(FileInputFormatterProvider inputProvider, FileOutputFormatterProvider outputProvider) {
        this.inputProvider = inputProvider;
        this.outputProvider = outputProvider;
        this.canWrite = outputProvider != null;
        this.canRead = inputProvider != null;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public <K, V> FileOutputFormatter<K, V> getFileOutputFormatter(Map<String, String> properties, @Nullable Schema schema) {
        if (this.outputProvider == null) {
            throw new IllegalArgumentException(String.format("Format '%s' cannot be used for writing", this.name()));
        }
        return this.outputProvider.create(properties, schema);
    }

    public FileInputFormatter getFileInputFormatter(Map<String, String> properties, @Nullable Schema schema) {
        if (this.inputProvider == null) {
            throw new IllegalArgumentException(String.format("Format '%s' cannot be used for reading.", this.name()));
        }
        return this.inputProvider.create(properties, schema);
    }

    @Nullable
    public Schema getSchema(@Nullable String pathField) {
        if (this.inputProvider == null) {
            throw new IllegalArgumentException(String.format("Format '%s' cannot be used for reading.", this.name()));
        }
        return this.inputProvider.getSchema(pathField);
    }

    public static FileFormat from(String format, Predicate<FileFormat> isValidFormat) {
        FileFormat fileFormat;
        try {
            fileFormat = FileFormat.valueOf(format.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(FileFormat.getExceptionMessage(format, isValidFormat));
        }
        if (!isValidFormat.test(fileFormat)) {
            throw new IllegalArgumentException(FileFormat.getExceptionMessage(format, isValidFormat));
        }
        return fileFormat;
    }

    private static String getExceptionMessage(String format, Predicate<FileFormat> isValid) {
        String values = Arrays.stream(FileFormat.values()).filter(isValid).map(f -> f.name().toLowerCase()).collect(Collectors.joining(", "));
        throw new IllegalArgumentException(String.format("Invalid format '%s'. The value must be one of %s", format, values));
    }
}

