/*
 * Decompiled with CFR 0.152.
 */
package co.cask.hydrator.format;

import co.cask.cdap.api.data.format.StructuredRecord;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.hydrator.common.RecordConverter;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class AvroToStructuredTransformer
extends RecordConverter<GenericRecord, StructuredRecord> {
    private final Map<Integer, co.cask.cdap.api.data.schema.Schema> schemaCache = Maps.newHashMap();

    public StructuredRecord transform(GenericRecord genericRecord) throws IOException {
        Schema genericRecordSchema = genericRecord.getSchema();
        return this.transform(genericRecord, this.convertSchema(genericRecordSchema));
    }

    public StructuredRecord transform(GenericRecord genericRecord, co.cask.cdap.api.data.schema.Schema structuredSchema) throws IOException {
        StructuredRecord.Builder builder = StructuredRecord.builder((co.cask.cdap.api.data.schema.Schema)structuredSchema);
        for (Schema.Field field : structuredSchema.getFields()) {
            String fieldName = field.getName();
            builder.set(fieldName, this.convertField(genericRecord.get(fieldName), field.getSchema()));
        }
        return builder.build();
    }

    public StructuredRecord.Builder transform(GenericRecord genericRecord, co.cask.cdap.api.data.schema.Schema structuredSchema, @Nullable String skipField) throws IOException {
        StructuredRecord.Builder builder = StructuredRecord.builder((co.cask.cdap.api.data.schema.Schema)structuredSchema);
        for (Schema.Field field : structuredSchema.getFields()) {
            String fieldName = field.getName();
            if (fieldName.equals(skipField)) continue;
            builder.set(fieldName, this.convertField(genericRecord.get(fieldName), field.getSchema()));
        }
        return builder;
    }

    public co.cask.cdap.api.data.schema.Schema convertSchema(Schema schema) throws IOException {
        co.cask.cdap.api.data.schema.Schema structuredSchema;
        int hashCode = schema.hashCode();
        if (this.schemaCache.containsKey(hashCode)) {
            structuredSchema = this.schemaCache.get(hashCode);
        } else {
            structuredSchema = co.cask.cdap.api.data.schema.Schema.parseJson((String)schema.toString());
            this.schemaCache.put(hashCode, structuredSchema);
        }
        return structuredSchema;
    }
}

