/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.zookeeper;

import co.cask.common.io.AsyncFunctions;
import co.cask.common.io.Codec;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.twill.common.Threads;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public final class ZKExtOperations {
    public static <V> ListenableFuture<V> createOrSet(ZKClient zkClient, String path, byte[] data, V result, int maxFailure) {
        return ZKExtOperations.setContent(zkClient, path, data, result, maxFailure, true, null);
    }

    public static <V> ListenableFuture<V> createOrSet(ZKClient zkClient, String path, byte[] data, V result, int maxFailure, List<ACL> createAcl) {
        return ZKExtOperations.setContent(zkClient, path, data, result, maxFailure, true, createAcl);
    }

    public static <V> ListenableFuture<V> setOrCreate(ZKClient zkClient, String path, byte[] data, V result, int maxFailure) {
        return ZKExtOperations.setContent(zkClient, path, data, result, maxFailure, false, null);
    }

    public static <V> ListenableFuture<V> updateOrCreate(ZKClient zkClient, String path, Function<V, V> modifier, Codec<V> codec) {
        return ZKExtOperations.updateOrCreate(zkClient, path, modifier, codec, null);
    }

    public static <V> ListenableFuture<V> updateOrCreate(ZKClient zkClient, String path, Function<V, V> modifier, Codec<V> codec, @Nullable List<ACL> createAcl) {
        SettableFuture resultFuture = SettableFuture.create();
        AsyncFunction asyncModifier = AsyncFunctions.asyncWrap(modifier);
        ZKExtOperations.getAndSet(zkClient, path, asyncModifier, codec, resultFuture, createAcl);
        return resultFuture;
    }

    public static <V> ListenableFuture<V> updateOrCreate(ZKClient zkClient, String path, AsyncFunction<V, V> modifier, Codec<V> codec) {
        return ZKExtOperations.updateOrCreate(zkClient, path, modifier, codec, null);
    }

    public static <V> ListenableFuture<V> updateOrCreate(ZKClient zkClient, String path, AsyncFunction<V, V> modifier, Codec<V> codec, @Nullable List<ACL> createAcl) {
        SettableFuture resultFuture = SettableFuture.create();
        ZKExtOperations.getAndSet(zkClient, path, modifier, codec, resultFuture, createAcl);
        return resultFuture;
    }

    public static <V> ListenableFuture<V> setOrCreate(ZKClient zkClient, String path, byte[] data, V result, int maxFailure, List<ACL> createAcl) {
        return ZKExtOperations.setContent(zkClient, path, data, result, maxFailure, false, createAcl);
    }

    private static <V> ListenableFuture<V> setContent(final ZKClient zkClient, final String path, final byte[] data, final V result, final int maxFailure, boolean createFirst, final List<ACL> createAcls) {
        final SettableFuture resultFuture = SettableFuture.create();
        final AtomicInteger failureCount = new AtomicInteger(0);
        OperationFuture operationFuture = createFirst ? (createAcls != null ? zkClient.create(path, data, CreateMode.PERSISTENT, createAcls) : zkClient.create(path, data, CreateMode.PERSISTENT)) : zkClient.setData(path, data);
        Futures.addCallback((ListenableFuture)operationFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object zkResult) {
                resultFuture.set(result);
            }

            public void onFailure(Throwable t) {
                if (failureCount.getAndIncrement() > maxFailure) {
                    resultFuture.setException((Throwable)new Exception("Failed more than " + maxFailure + "times", t));
                } else if (t instanceof KeeperException.NoNodeException) {
                    OperationFuture createFuture = createAcls != null ? zkClient.create(path, data, CreateMode.PERSISTENT, (Iterable)createAcls) : zkClient.create(path, data, CreateMode.PERSISTENT);
                    Futures.addCallback((ListenableFuture)createFuture, (FutureCallback)this, (Executor)Threads.SAME_THREAD_EXECUTOR);
                } else if (t instanceof KeeperException.NodeExistsException) {
                    Futures.addCallback((ListenableFuture)zkClient.setData(path, data), (FutureCallback)this, (Executor)Threads.SAME_THREAD_EXECUTOR);
                } else {
                    resultFuture.setException(t);
                }
            }
        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
        return resultFuture;
    }

    private static <V> void getAndSet(final ZKClient zkClient, final String path, final AsyncFunction<V, V> modifier, final Codec<V> codec, final SettableFuture<V> resultFuture, final List<ACL> createAcl) {
        Futures.addCallback((ListenableFuture)zkClient.getData(path), (FutureCallback)new FutureCallback<NodeData>(){

            public void onSuccess(final NodeData result) {
                try {
                    final int version = result.getStat().getVersion();
                    Futures.addCallback((ListenableFuture)modifier.apply(codec.decode(result.getData())), (FutureCallback)new FutureCallback<V>(){

                        public void onSuccess(final V content) {
                            if (content == null) {
                                resultFuture.set(null);
                                return;
                            }
                            try {
                                byte[] data = codec.encode(content);
                                if (Arrays.equals(data, result.getData())) {
                                    resultFuture.set(content);
                                    return;
                                }
                                Futures.addCallback((ListenableFuture)zkClient.setData(path, data, version), (FutureCallback)new FutureCallback<Stat>(){

                                    public void onSuccess(Stat result) {
                                        resultFuture.set(content);
                                    }

                                    public void onFailure(Throwable t) {
                                        if (t instanceof KeeperException.BadVersionException) {
                                            ZKExtOperations.getAndSet(zkClient, path, modifier, codec, resultFuture, createAcl);
                                        } else if (t instanceof KeeperException.NoNodeException) {
                                            ZKExtOperations.createOrGetAndSet(zkClient, path, modifier, codec, resultFuture, createAcl);
                                        } else {
                                            resultFuture.setException(t);
                                        }
                                    }
                                }, (Executor)Threads.SAME_THREAD_EXECUTOR);
                            }
                            catch (Throwable t) {
                                resultFuture.setException(t);
                            }
                        }

                        public void onFailure(Throwable t) {
                            resultFuture.setException(t);
                        }
                    }, (Executor)Threads.SAME_THREAD_EXECUTOR);
                }
                catch (Throwable t) {
                    resultFuture.setException(t);
                }
            }

            public void onFailure(Throwable t) {
                if (t instanceof KeeperException.NoNodeException) {
                    ZKExtOperations.createOrGetAndSet(zkClient, path, modifier, codec, resultFuture, createAcl);
                } else {
                    resultFuture.setException(t);
                }
            }
        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
    }

    private static <V> void createOrGetAndSet(final ZKClient zkClient, final String path, final AsyncFunction<V, V> modifier, final Codec<V> codec, final SettableFuture<V> resultFuture, final List<ACL> createAcl) {
        try {
            Futures.addCallback((ListenableFuture)modifier.apply(null), (FutureCallback)new FutureCallback<V>(){

                public void onSuccess(final V content) {
                    if (content == null) {
                        resultFuture.set(null);
                        return;
                    }
                    try {
                        byte[] data = codec.encode(content);
                        OperationFuture future = createAcl == null ? zkClient.create(path, data, CreateMode.PERSISTENT) : zkClient.create(path, data, CreateMode.PERSISTENT, (Iterable)createAcl);
                        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<String>(){

                            public void onSuccess(String result) {
                                resultFuture.set(content);
                            }

                            public void onFailure(Throwable t) {
                                if (t instanceof KeeperException.NodeExistsException) {
                                    ZKExtOperations.getAndSet(zkClient, path, modifier, codec, resultFuture, createAcl);
                                } else {
                                    resultFuture.setException(t);
                                }
                            }
                        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
                    }
                    catch (Throwable t) {
                        resultFuture.setException(t);
                    }
                }

                public void onFailure(Throwable t) {
                    resultFuture.setException(t);
                }
            }, (Executor)Threads.SAME_THREAD_EXECUTOR);
        }
        catch (Throwable e) {
            resultFuture.setException(e);
        }
    }

    private ZKExtOperations() {
    }
}

