/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.handler.ssl.SslHandler;

public class SSLHandlerFactory {
    private static final String protocol = "TLS";
    private final SSLContext serverContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLHandlerFactory(File keyStore, String keyStoreType, String keyStorePassword, String certificatePassword) {
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store Path Not Configured");
        }
        if (keyStorePassword == null) {
            throw new IllegalArgumentException("KeyStore Password Not Configured");
        }
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance(keyStoreType);
            FileInputStream inputStream = new FileInputStream(keyStore);
            try {
                ks.load(inputStream, keyStorePassword.toCharArray());
            }
            finally {
                ((InputStream)inputStream).close();
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, certificatePassword != null ? certificatePassword.toCharArray() : keyStorePassword.toCharArray());
            this.serverContext = SSLContext.getInstance(protocol);
            this.serverContext.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to initialize the server-side SSLContext", e);
        }
    }

    public SslHandler create() {
        SSLEngine engine = this.serverContext.createSSLEngine();
        engine.setUseClientMode(false);
        SslHandler handler = new SslHandler(engine);
        handler.setEnableRenegotiation(false);
        return handler;
    }
}

