/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.security.server.LDAPAuthenticationHandler;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.plus.jaas.spi.LdapLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPLoginModule
extends LdapLoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(LDAPLoginModule.class);

    public Hashtable<Object, Object> getEnvironment() {
        Hashtable table = super.getEnvironment();
        if (!LDAPAuthenticationHandler.getLdapSSLVerifyCertificate()) {
            table.put("java.naming.ldap.factory.socket", TrustAllSSLSocketFactory.class.getName());
        }
        return table;
    }

    public static class TrustAllSSLSocketFactory
    extends SocketFactory {
        private final SocketFactory trustAllFactory;

        private TrustAllSSLSocketFactory() {
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustManagers, new SecureRandom());
                this.trustAllFactory = sc.getSocketFactory();
            }
            catch (GeneralSecurityException e) {
                LOG.error("Could not disable certificate verification for connections to LDAP.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }

        public static SocketFactory getDefault() {
            return new TrustAllSSLSocketFactory();
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.trustAllFactory.createSocket(host, port);
        }

        @Override
        public Socket createSocket(InetAddress address, int port) throws IOException {
            return this.trustAllFactory.createSocket(address, port);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.trustAllFactory.createSocket(host, port, localHost, localPort);
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.trustAllFactory.createSocket(address, port, localAddress, localPort);
        }
    }
}

