/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.server.JAASAuthenticationHandler;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class LDAPAuthenticationHandler
extends JAASAuthenticationHandler {
    private static final List<String> mandatoryConfigurables = ImmutableList.of((Object)"debug", (Object)"hostname", (Object)"port", (Object)"userBaseDn", (Object)"userRdnAttribute", (Object)"userObjectClass");
    private static final List<String> optionalConfigurables = ImmutableList.of((Object)"bindDn", (Object)"bindPassword", (Object)"useLdaps", (Object)"userIdAttribute", (Object)"userPasswordAttribute", (Object)"roleBaseDn", (Object)"roleNameAttribute", (Object)"roleMemberAttribute", (Object)"roleObjectClass");
    private static boolean ldapSSLVerifyCertificate = true;

    @Inject
    public LDAPAuthenticationHandler(SecurityConfiguration configuration) throws Exception {
        super(configuration);
    }

    @Override
    protected Configuration getLoginModuleConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String s) {
                HashMap map = Maps.newHashMap();
                map.put("contextFactory", "com.sun.jndi.ldap.LdapCtxFactory");
                map.put("authenticationMethod", "simple");
                map.put("forceBindingLogin", "true");
                String authConfigBase = "security.authentication.handler.";
                for (String configurable : mandatoryConfigurables) {
                    String key = authConfigBase.concat(configurable);
                    String value = LDAPAuthenticationHandler.this.configuration.get(key);
                    if (value == null) {
                        String errorMessage = String.format("Mandatory configuration %s is not set.", key);
                        throw Throwables.propagate((Throwable)new RuntimeException(errorMessage));
                    }
                    map.put(configurable, value);
                }
                for (String configurable : optionalConfigurables) {
                    String value = LDAPAuthenticationHandler.this.configuration.get(authConfigBase.concat(configurable));
                    if (value == null) continue;
                    map.put(configurable, value);
                }
                ldapSSLVerifyCertificate = LDAPAuthenticationHandler.this.configuration.getBoolean(authConfigBase.concat("ldapsVerifyCertificate"), true);
                return new AppConfigurationEntry[]{new AppConfigurationEntry(LDAPAuthenticationHandler.this.configuration.get("security.authentication.loginmodule.className"), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map)};
            }
        };
    }

    static boolean getLdapSSLVerifyCertificate() {
        return ldapSSLVerifyCertificate;
    }
}

