/*
 * Decompiled with CFR 0.152.
 */
package co.cask.common.security.server;

import co.cask.common.security.config.SecurityConfiguration;
import co.cask.common.security.server.AbstractAuthenticationHandler;
import co.cask.common.security.server.JAASLoginService;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.message.config.ServerAuthConfig;
import org.apache.geronimo.components.jaspi.impl.ServerAuthConfigImpl;
import org.apache.geronimo.components.jaspi.impl.ServerAuthContextImpl;
import org.apache.geronimo.components.jaspi.model.AuthModuleType;
import org.apache.geronimo.components.jaspi.model.ServerAuthConfigType;
import org.apache.geronimo.components.jaspi.model.ServerAuthContextType;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.jaspi.JaspiAuthenticator;
import org.eclipse.jetty.security.jaspi.JaspiAuthenticatorFactory;
import org.eclipse.jetty.security.jaspi.ServletCallbackHandler;
import org.eclipse.jetty.security.jaspi.modules.BasicAuthModule;

public class JASPIAuthenticationHandler
extends AbstractAuthenticationHandler {
    private JAASLoginService loginService;
    private IdentityService identityService;

    @Inject
    public JASPIAuthenticationHandler(SecurityConfiguration configuration) throws Exception {
        super(configuration);
    }

    @Override
    protected LoginService getHandlerLoginService() {
        if (this.loginService == null) {
            this.loginService = new JAASLoginService();
            this.loginService.setLoginModuleName("JASPI");
            this.loginService.setSecurityConfiguration(this.getLoginModuleConfiguration());
            this.loginService.setIdentityService(this.getHandlerIdentityService());
        }
        return this.loginService;
    }

    @Override
    protected Authenticator getHandlerAuthenticator() {
        JaspiAuthenticatorFactory jaspiAuthenticatorFactory = new JaspiAuthenticatorFactory();
        jaspiAuthenticatorFactory.setLoginService(this.getHandlerLoginService());
        HashMap<String, ServerAuthContextImpl> serverAuthContextMap = new HashMap<String, ServerAuthContextImpl>();
        ServletCallbackHandler callbackHandler = new ServletCallbackHandler(this.getHandlerLoginService());
        BasicAuthModule authModule = new BasicAuthModule((CallbackHandler)callbackHandler, "JAASRealm");
        serverAuthContextMap.put("authContextID", new ServerAuthContextImpl(Collections.singletonList(authModule)));
        ServerAuthContextType serverAuthContextType = new ServerAuthContextType("HTTP", "server *", "authContextID", new AuthModuleType());
        ServerAuthConfigType serverAuthConfigType = new ServerAuthConfigType(serverAuthContextType, true);
        ServerAuthConfigImpl serverAuthConfig = new ServerAuthConfigImpl(serverAuthConfigType, serverAuthContextMap);
        JaspiAuthenticator jaspiAuthenticator = new JaspiAuthenticator((ServerAuthConfig)serverAuthConfig, null, callbackHandler, new Subject(), true, this.getHandlerIdentityService());
        return jaspiAuthenticator;
    }

    @Override
    protected IdentityService getHandlerIdentityService() {
        if (this.identityService == null) {
            this.identityService = new DefaultIdentityService();
        }
        return this.identityService;
    }

    @Override
    protected Configuration getLoginModuleConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String s) {
                HashMap<String, String> map = new HashMap<String, String>();
                String configRegex = "security.authentication.handler.".replace(".", "\\.").concat(".");
                HashMap configurables = (HashMap)JASPIAuthenticationHandler.this.configuration.getValByRegex(configRegex);
                for (Map.Entry pairs : configurables.entrySet()) {
                    String key = pairs.getKey().toString();
                    String value = pairs.getValue().toString();
                    map.put(key.substring(key.lastIndexOf(46) + 1).trim(), value);
                }
                return new AppConfigurationEntry[]{new AppConfigurationEntry(JASPIAuthenticationHandler.this.configuration.get("security.authentication.loginmodule.className"), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map)};
            }
        };
    }
}

